/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.model;

import net.anwiba.commons.lang.functional.IProcedure;
import net.anwiba.commons.model.IChangeableListListener;
import net.anwiba.commons.model.IListChangedNotifier;
import net.anwiba.commons.model.ListenerList;

public class AbstractListChangedNotifier<T>
implements IListChangedNotifier<T> {
    private final ListenerList<IChangeableListListener<T>> listModelListeners = new ListenerList();

    @Override
    public final synchronized void addListModelListener(IChangeableListListener<T> listener) {
        this.listModelListeners.add(listener);
    }

    @Override
    public final synchronized void removeListModelListener(IChangeableListListener<T> listener) {
        this.listModelListeners.remove(listener);
    }

    protected void fireObjectsChanged(final Iterable<T> oldObjects, final Iterable<T> newObjects) {
        this.listModelListeners.forAllDo(new IProcedure<IChangeableListListener<T>, RuntimeException>(){

            @Override
            public void execute(IChangeableListListener<T> listener) throws RuntimeException {
                listener.objectsChanged(oldObjects, newObjects);
            }
        });
    }

    protected final synchronized void fireObjectsAdded(final Iterable<Integer> indeces, final Iterable<T> objects) {
        this.listModelListeners.forAllDo(new IProcedure<IChangeableListListener<T>, RuntimeException>(){

            @Override
            public void execute(IChangeableListListener<T> listener) throws RuntimeException {
                listener.objectsAdded(indeces, objects);
            }
        });
    }

    protected final synchronized void fireObjectsUpdated(final Iterable<Integer> indeces, final Iterable<T> oldObjects, final Iterable<T> newObjects) {
        this.listModelListeners.forAllDo(new IProcedure<IChangeableListListener<T>, RuntimeException>(){

            @Override
            public void execute(IChangeableListListener<T> listener) throws RuntimeException {
                listener.objectsUpdated(indeces, oldObjects, newObjects);
            }
        });
    }

    protected final synchronized void fireObjectsRemoved(final Iterable<Integer> indeces, final Iterable<T> objects) {
        this.listModelListeners.forAllDo(new IProcedure<IChangeableListListener<T>, RuntimeException>(){

            @Override
            public void execute(IChangeableListListener<T> listener) throws RuntimeException {
                listener.objectsRemoved(indeces, objects);
            }
        });
    }
}

