/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.object.ObjectUtilities;

public class ArrayUtilities {
    public static int getMin(int[] values) {
        int result = Integer.MAX_VALUE;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            if (value < result) {
                result = value;
            }
            ++n2;
        }
        return result;
    }

    public static int getMax(int[] values) {
        int result = Integer.MAX_VALUE;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            if (value > result) {
                result = value;
            }
            ++n2;
        }
        return result;
    }

    public static double getMin(double[] values) {
        double result = Double.POSITIVE_INFINITY;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            if (!Double.isNaN(value) && value < result) {
                result = value;
            }
            ++n2;
        }
        return result;
    }

    public static double getMax(double[] values) {
        double result = Double.NEGATIVE_INFINITY;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            if (!Double.isNaN(value) && value > result) {
                result = value;
            }
            ++n2;
        }
        return result;
    }

    public static byte[] concat(byte[] values0, byte[] values1) {
        if (values0.length == 0) {
            return ArrayUtilities.copy(values1);
        }
        if (values1.length == 0) {
            return ArrayUtilities.copy(values0);
        }
        return ArrayUtilities.concat(values0, values1, values1.length);
    }

    public static byte[] concat(byte[] values0, byte[] values1, int length) {
        byte[] result = new byte[values0.length + length];
        System.arraycopy(values0, 0, result, 0, values0.length);
        System.arraycopy(values1, 0, result, values0.length, length);
        return result;
    }

    public static byte[] copy(byte[] values1) {
        byte[] result = new byte[values1.length];
        System.arraycopy(values1, 0, result, 0, values1.length);
        return result;
    }

    public static int[] concat(int[] values0, int ... values1) {
        if (values0.length == 0) {
            return ArrayUtilities.copy(values1);
        }
        if (values1.length == 0) {
            return ArrayUtilities.copy(values0);
        }
        int[] result = new int[values0.length + values1.length];
        System.arraycopy(values0, 0, result, 0, values0.length);
        System.arraycopy(values1, 0, result, values0.length, values1.length);
        return result;
    }

    public static int[] copy(int[] values) {
        int[] result = new int[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static double[] concat(double[] values0, double[] values1) {
        if (values0.length == 0) {
            return ArrayUtilities.copy(values1);
        }
        if (values1.length == 0) {
            return ArrayUtilities.copy(values0);
        }
        double[] result = new double[values0.length + values1.length];
        System.arraycopy(values0, 0, result, 0, values0.length);
        System.arraycopy(values1, 0, result, values0.length, values1.length);
        return result;
    }

    public static double[] copy(double[] values) {
        double[] result = new double[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static <T> T[] copy(T[] array) {
        return ArrayUtilities.copy(array.getClass().getComponentType(), array);
    }

    public static <O, T extends O> O[] copy(Class<O> clazz, T[] array) {
        if (array == null) {
            return array;
        }
        O[] target = ArrayUtilities.create(clazz, array.length);
        System.arraycopy(array, 0, target, 0, array.length);
        return target;
    }

    public static <O, T extends O> O[] concat(Class<O> clazz, T[] array1, T ... array2) {
        if (array2 == null || array2.length == 0) {
            return array1;
        }
        if (array1 == null || array1.length == 0) {
            return array2;
        }
        O[] mergedArray = ArrayUtilities.create(clazz, array1.length + array2.length);
        System.arraycopy(array1, 0, mergedArray, 0, array1.length);
        System.arraycopy(array2, 0, mergedArray, array1.length, array2.length);
        return mergedArray;
    }

    public static <O, T extends O> O[] concat(Class<O> clazz, T object, T ... array) {
        O[] objects = ArrayUtilities.asArray(clazz, object);
        return ArrayUtilities.concat(clazz, objects, array);
    }

    public static <O, T extends O> O[] asArray(Class<O> clazz, T object) {
        O[] array = ArrayUtilities.create(clazz, 1);
        array[0] = object;
        return array;
    }

    public static double[] reverse(double[] values) {
        int n = values.length;
        double[] reverse = new double[n];
        int i = 0;
        while (i < n) {
            reverse[n - 1 - i] = values[i];
            ++i;
        }
        return reverse;
    }

    public static boolean allValuesNaN(double[] values) {
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            if (!Double.isNaN(value)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean contains(int[] values, int value) {
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <I, O, E extends Exception> O[] convert(IConverter<I, O, E> converter, I[] values, Class<O> clazz) throws E {
        ArrayList<O> list = new ArrayList<O>();
        I[] IArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            I value = IArray[n2];
            O result = converter.convert(value);
            if (result != null) {
                list.add(result);
            }
            ++n2;
        }
        int length = values.length;
        O[] array = ArrayUtilities.create(clazz, length);
        return list.toArray(array);
    }

    public static <C> boolean instanceOf(Object[] objects, Class<C> clazz) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (!clazz.isInstance(object)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static <O, T extends O> O[] remove(O[] source, T value, Class<O> clazz) {
        ArrayList<O> list = new ArrayList<O>();
        O[] OArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            O item = OArray[n2];
            if (!ObjectUtilities.equals(value, item)) {
                list.add(item);
            }
            ++n2;
        }
        return ArrayUtilities.toArray(clazz, list);
    }

    private static <O, T extends O> O[] toArray(Class<O> clazz, List<T> list) {
        O[] target = ArrayUtilities.create(clazz, list.size());
        int i = 0;
        while (i < target.length) {
            target[i] = list.get(i);
            ++i;
        }
        return target;
    }

    public static <T> T[] filter(T[] array, IAcceptor<T> validator) {
        return ArrayUtilities.filter(array.getClass().getComponentType(), array, validator);
    }

    public static <O, T extends O> O[] filter(Class<O> clazz, T[] array, IAcceptor<O> validator) {
        ArrayList<T> list = new ArrayList<T>();
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            if (validator.accept(item)) {
                list.add(item);
            }
            ++n2;
        }
        return ArrayUtilities.toArray(clazz, list);
    }

    public static <T> T findFirst(T[] values, IAcceptor<T> validator) {
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            if (validator.accept(value)) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    public static int[] primitives(Integer[] array) {
        int[] result = new int[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i];
            ++i;
        }
        return result;
    }

    public static double[] primitives(Double[] array) {
        double[] result = new double[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i];
            ++i;
        }
        return result;
    }

    public static byte[] primitives(Byte[] array) {
        byte[] result = new byte[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i];
            ++i;
        }
        return result;
    }

    public static <T> int indexOf(T[] objects, IAcceptor<T> validator) {
        int index = 0;
        while (index < objects.length) {
            if (validator.accept(objects[index])) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static Short[] objects(short[] array) {
        Short[] result = new Short[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i];
            ++i;
        }
        return result;
    }

    public static Integer[] objects(int[] array) {
        Integer[] result = new Integer[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i];
            ++i;
        }
        return result;
    }

    public static Long[] objects(long[] array) {
        Long[] result = new Long[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i];
            ++i;
        }
        return result;
    }

    public static Float[] objects(float[] array) {
        Float[] result = new Float[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = Float.valueOf(array[i]);
            ++i;
        }
        return result;
    }

    public static Double[] objects(double[] array) {
        Double[] result = new Double[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i];
            ++i;
        }
        return result;
    }

    public static Byte[] objects(byte[] array) {
        Byte[] result = new Byte[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i];
            ++i;
        }
        return result;
    }

    public static Character[] objects(char[] array) {
        Character[] result = new Character[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = Character.valueOf(array[i]);
            ++i;
        }
        return result;
    }

    public static Boolean[] objects(boolean[] array) {
        Boolean[] result = new Boolean[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i];
            ++i;
        }
        return result;
    }

    public static <T> T[] create(T ... objects) {
        return objects;
    }

    public static <T> T[] normalize(T ... values) {
        ArrayList<T> list = new ArrayList<T>(values.length);
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (t != null) {
                list.add(t);
            }
            ++n2;
        }
        return ArrayUtilities.toArray(values.getClass().getComponentType(), list);
    }

    public static <T> T[] create(Class<T> clazz, int size) {
        return (Object[])Array.newInstance(clazz, size);
    }

    public static <T> boolean contains(T[] array, T object) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            if (ObjectUtilities.equals(item, object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

