/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.color;

import java.awt.Color;

public class ColorBuilder {
    private Color color;
    private float opacity = 1.0f;

    public ColorBuilder() {
        this(Color.BLACK);
    }

    public ColorBuilder(Color color) {
        this.color = color;
    }

    public ColorBuilder setColor(String color) {
        this.color = Color.decode(color);
        return this;
    }

    public ColorBuilder setColor(Color color) {
        this.color = color;
        return this;
    }

    public ColorBuilder setOpacity(float opacity) {
        this.opacity = opacity;
        return this;
    }

    public Color build() {
        float[] rgb = this.color.getRGBColorComponents(null);
        return new Color(rgb[0], rgb[1], rgb[2], this.opacity);
    }
}

