/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import net.anwiba.commons.utilities.time.ZonedDateTimeUtilities;

public class LocalDateTimeUtilities {
    public static LocalDateTime atCoordinatedUniversalTimeZone(ZonedDateTime dateTime) {
        return LocalDateTimeUtilities.atZone(dateTime, ZonedDateTimeUtilities.getCoordinatedUniversalTimeZone());
    }

    public static LocalDateTime atZone(ZonedDateTime dateTime, ZoneId targetZone) {
        return dateTime.toInstant().atZone(targetZone).toLocalDateTime();
    }

    public static LocalDateTime atZone(java.sql.Date date, ZoneId zone) {
        return LocalDateTimeUtilities.atZone(new Date(date.getTime()), zone);
    }

    public static LocalDateTime atZone(Date date, ZoneId zone) {
        return LocalDateTime.ofInstant(date.toInstant(), zone);
    }

    public static LocalDateTime atZone(LocalDateTime sourceDateTime, ZoneId sourceZone, ZoneId targetZone) {
        if (Objects.equals(sourceZone, targetZone)) {
            return sourceDateTime;
        }
        ZonedDateTime zonedSourceDateTime = sourceDateTime.atZone(sourceZone);
        ZonedDateTime zonedTargetDateTime = zonedSourceDateTime.toInstant().atZone(targetZone);
        return zonedTargetDateTime.toLocalDateTime();
    }

    public static String toString(LocalDateTime dateTime) {
        return dateTime.format(new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).toFormatter(Locale.getDefault())).toFormatter(Locale.getDefault()));
    }

    public static LocalDateTime atCoordinatedUniversalTimeZone(java.sql.Date date) {
        return LocalDateTimeUtilities.atCoordinatedUniversalTimeZone(new Date(date.getTime()));
    }

    private static LocalDateTime atCoordinatedUniversalTimeZone(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZonedDateTimeUtilities.getCoordinatedUniversalTimeZone());
    }
}

