/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.stream;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IAccumulator;
import net.anwiba.commons.lang.functional.IConsumer;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.IIterable;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.ConvertingIterableIterable;
import net.anwiba.commons.lang.stream.FilteringIterableIterable;
import net.anwiba.commons.lang.stream.IStream;

class SequencedStream<T, E extends Exception>
implements IStream<T, E> {
    private final IIterable<T, E> iterable;

    SequencedStream(IIterable<T, E> iterable) {
        this.iterable = iterable;
    }

    @Override
    public <O> IStream<O, E> convert(IConverter<T, O, E> converter) {
        return new SequencedStream<T, E>(new ConvertingIterableIterable<Object, O, E>(this.iterable, i -> i != null, converter));
    }

    @Override
    public IStream<T, E> distinct() {
        HashSet set = new HashSet();
        return this.filter(i -> !set.add(i));
    }

    @Override
    public IStream<T, E> filter(IAcceptor<T> acceptor) {
        return new SequencedStream<T, E>(new FilteringIterableIterable<T, E>(this.iterable, acceptor));
    }

    @Override
    public void foreach(IConsumer<T, E> consumer) throws E {
        this.iterable.foreach(consumer);
    }

    @Override
    public IOptional<T, E> first() throws E {
        return Optional.create(this.iterable.first((O v) -> true));
    }

    @Override
    public IOptional<T, E> first(IAcceptor<T> acceptor) throws E {
        return Optional.create(this.iterable.first(acceptor));
    }

    @Override
    public Iterable<T> asIterable() throws E {
        return this.iterable.foreach(new LinkedList(), (R l, O t) -> {
            l.add(t);
            return l;
        });
    }

    @Override
    public Collection<T> asCollection() throws E {
        return this.asList();
    }

    @Override
    public <O> List<O> asList() throws E {
        return this.iterable.foreach(new ArrayList(), (R l, O t) -> {
            l.add(t);
            return l;
        });
    }

    @Override
    public IObjectList<T> asObjectList() throws E {
        return new ObjectList(this.asList());
    }

    @Override
    public <O> IOptional<O, E> foreach(O identity, IAccumulator<T, O, E> adder) throws E {
        return Optional.create(this.iterable.foreach(identity, adder));
    }
}

