/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.tree;

import net.anwiba.commons.lang.tree.ITreeItem;

class TreeItem<K, V>
implements ITreeItem<K, V> {
    public static final int LEFT = -1;
    public static final int BALANCED = 0;
    public static final int RIGHT = 1;
    private K key = null;
    private V element = null;
    TreeItem<K, V> prev;
    TreeItem<K, V> next;
    TreeItem<K, V> parent = null;
    TreeItem<K, V> left = null;
    TreeItem<K, V> right = null;
    int balanced = 0;

    TreeItem() {
    }

    TreeItem(K key, V element) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.key = key;
        this.element = element;
    }

    @Override
    public int getBalanced() {
        return this.balanced;
    }

    @Override
    public ITreeItem<K, V> getParent() {
        return this.parent;
    }

    @Override
    public ITreeItem<K, V> getLeft() {
        return this.left;
    }

    @Override
    public ITreeItem<K, V> getRight() {
        return this.right;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getElement() {
        return this.element;
    }

    public void setElement(V element) {
        this.element = element;
    }

    public TreeItem<K, V> clone() {
        TreeItem<K, V> object = null;
        object = new TreeItem<K, V>(this.key, this.element);
        object.parent = this.parent;
        object.left = this.left;
        object.right = this.right;
        object.balanced = this.balanced;
        return object;
    }

    @Override
    public ITreeItem<K, V> getNext() {
        return this.next;
    }

    @Override
    public ITreeItem<K, V> getPrevious() {
        return this.prev;
    }
}

