/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.tree.iterator;

import java.util.LinkedList;
import net.anwiba.commons.lang.object.IObjectIterator;
import net.anwiba.commons.lang.tree.ITreeItem;

public class DeepFirstSearchValueIterator<K, V>
implements IObjectIterator<V> {
    private final LinkedList<ITreeItem<K, V>> queue = new LinkedList();
    private ITreeItem<K, V> item = null;

    public DeepFirstSearchValueIterator(ITreeItem<K, V> item) {
        this.initalize(item);
    }

    private void initalize(ITreeItem<K, V> item) {
        if (item != null) {
            this.queue.add(item);
            if (item.getLeft() != null) {
                this.initalize(item.getLeft());
            }
            if (item.getRight() != null) {
                this.initalize(item.getRight());
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.item != null) {
            return true;
        }
        if (this.queue.isEmpty()) {
            return false;
        }
        this.item = this.queue.removeFirst();
        return this.item != null;
    }

    @Override
    public V next() {
        if (this.item == null || !this.hasNext()) {
            return null;
        }
        try {
            V v = this.item == null ? null : (V)this.item.getElement();
            return v;
        }
        finally {
            this.item = null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasPrevious() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V previous() {
        throw new UnsupportedOperationException();
    }
}

