/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.ensure;

import net.anwiba.commons.ensure.ICondition;
import net.anwiba.commons.lang.exception.ContractFailedException;

public class Ensure {
    public static void ensureArgumentNotNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("argument is null");
        }
    }

    public static void ensureArgumentNotZero(double value) {
        if (value == 0.0 || Double.isNaN(value)) {
            throw new IllegalArgumentException("argument is zero");
        }
    }

    public static void ensureArgumentIsInside(int value, int min, int max) {
        if (value < min || max < value) {
            throw new IllegalArgumentException("argument is not inside [" + min + " .. " + max + "]");
        }
    }

    public static void ensureArgumentsEqual(int value, int other) {
        if (value != other) {
            throw new IllegalArgumentException("argument are not equal");
        }
    }

    public static void ensureArgumentIsNotEmpty(Object[] array) {
        Ensure.ensureArgumentNotNull(array);
        if (array.length == 0) {
            throw new IllegalArgumentException("array is empty");
        }
    }

    public static void ensureArgumentContentIsGreaterThan(int value, int limit) {
        if (value <= limit) {
            throw new IllegalArgumentException("arguments number of content is not greater than " + limit);
        }
    }

    public static void ensureArgumentIsNotEmpty(String value) {
        Ensure.ensureArgumentNotNull(value);
        if (value.trim().length() == 0) {
            throw new IllegalArgumentException("arrgument length is 0");
        }
    }

    public static void ensureArgumentIsInside(double value, double min, double max) {
        if (value < min || max < value) {
            throw new IllegalArgumentException("argument is not inside [" + min + " .. " + max + "]");
        }
    }

    public static void ensureArgumentNull(String message, Object object) {
        if (object == null) {
            return;
        }
        throw new IllegalArgumentException(message);
    }

    public static <T> void ensureThat(T actual, ICondition<T> condition) {
        if (!condition.accept(actual)) {
            throw new ContractFailedException(Ensure.message(actual, condition));
        }
    }

    public static <T> void ensureThatArgument(T actual, ICondition<T> condition) {
        if (!condition.accept(actual)) {
            throw new IllegalArgumentException(Ensure.message(actual, condition));
        }
    }

    public static <T> void ensureThatArgument(String message, T actual, ICondition<T> condition) {
        if (!condition.accept(actual)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> void ensureThat(String message, T actual, ICondition<T> condition) {
        if (!condition.accept(actual)) {
            throw new ContractFailedException(message);
        }
    }

    private static <T> String message(T actual, ICondition<T> condition) {
        StringBuilder builder = new StringBuilder();
        builder.append("Expected predicate: ").append(condition.toText()).append("\n     got: ").append(actual).append("\n");
        return builder.toString();
    }
}

