/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.color;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.utilities.color.ColorUtilities;
import net.anwiba.commons.utilities.color.IColorInterval;

public class ColorInterval
implements IColorInterval {
    private static final long serialVersionUID = 1L;
    private final Color minColor;
    private final Color maxColor;
    private final Map<Integer, Color> cache = new HashMap<Integer, Color>();
    private final int numberOfColors;

    public ColorInterval(Color minColor, Color maxColor) {
        this.minColor = minColor;
        this.maxColor = maxColor;
        this.numberOfColors = ColorInterval.calulateNumberOfColors(minColor, maxColor);
    }

    private static int calulateNumberOfColors(Color minColor, Color maxColor) {
        int result = 0;
        result = Math.max(result, ColorInterval.calculateDiffernce(minColor.getAlpha(), maxColor.getAlpha()));
        result = Math.max(result, ColorInterval.calculateDiffernce(minColor.getBlue(), maxColor.getBlue()));
        result = Math.max(result, ColorInterval.calculateDiffernce(minColor.getGreen(), maxColor.getGreen()));
        result = Math.max(result, ColorInterval.calculateDiffernce(minColor.getRed(), maxColor.getRed()));
        return result;
    }

    private static int calculateDiffernce(int value, int other) {
        return Math.max(value, other) - Math.min(value, other);
    }

    @Override
    public Color get(double fraction) {
        Integer key = fraction == 0.0 ? 0 : (int)Math.round((double)this.numberOfColors / Math.abs(fraction));
        if (this.cache.containsKey(key)) {
            this.cache.get(key);
        }
        Color color = ColorUtilities.create(this.minColor, this.maxColor, fraction);
        this.cache.put(key, color);
        return color;
    }

    @Override
    public Color getMinimumColor() {
        return this.minColor;
    }

    @Override
    public Color getMaximumColor() {
        return this.maxColor;
    }

    public int hashCode() {
        return ObjectUtilities.hashCode(this.getMinimumColor(), this.getMaximumColor());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IColorInterval)) {
            return false;
        }
        IColorInterval other = (IColorInterval)obj;
        return ObjectUtilities.equals(this.getMinimumColor(), other.getMinimumColor()) && ObjectUtilities.equals(this.getMaximumColor(), other.getMaximumColor());
    }
}

