/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.regex.tokenizer;

import java.util.regex.Matcher;
import net.anwiba.commons.ensure.Conditions;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.lang.functional.ConversionException;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.utilities.regex.tokenizer.IRegExpTokenConverter;
import net.anwiba.commons.utilities.regex.tokenizer.RegExpUtilities;
import net.anwiba.commons.utilities.string.IStringAppender;

public class RegExpTokenizingConverter {
    private final IConverter<String, String, RuntimeException> converter;
    private final IRegExpTokenConverter[] converters;

    public RegExpTokenizingConverter(IConverter<String, String, RuntimeException> converter, IRegExpTokenConverter ... converters) {
        Ensure.ensureThatArgument(converters, Conditions.notNull());
        Ensure.ensureThatArgument(converter, Conditions.notNull());
        this.converters = converters;
        this.converter = converter;
    }

    public RegExpTokenizingConverter(IRegExpTokenConverter converter, IConverter<String, String, RuntimeException> remainingPartsConverter) {
        this(remainingPartsConverter, converter);
    }

    public String convert(String text, IStringAppender appender) throws ConversionException {
        this.convert(0, text, appender);
        return appender.toString();
    }

    private void convert(int converterIndex, String text, IStringAppender appender) throws ConversionException {
        if (converterIndex >= this.converters.length) {
            if (text.length() > 0) {
                appender.append(this.converter.convert(text));
            }
            return;
        }
        int position = 0;
        IRegExpTokenConverter matchingConverter = this.converters[converterIndex];
        Matcher matcher = matchingConverter.getRegExpPattern().matcher(text);
        while (position < text.length() && matcher.find(position)) {
            if (matcher.start() > position) {
                this.convert(converterIndex + 1, text.substring(position, matcher.start()), appender);
            }
            String[] groups = RegExpUtilities.getGroups(matcher);
            appender.append(matchingConverter.convert(groups));
            position = matcher.end();
            matcher = matchingConverter.getRegExpPattern().matcher(text);
        }
        if (position < text.length()) {
            this.convert(converterIndex + 1, text.substring(position), appender);
        }
    }
}

