/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.tree.distance;

import net.anwiba.commons.lang.tree.distance.IObjectDistanceCalculator;

public final class LevenshteinStringDistanceCalculator
implements IObjectDistanceCalculator<String> {
    @Override
    public double calculate(String string, String other) {
        if (string == null || other == null) {
            throw new IllegalArgumentException();
        }
        int stringLength = string.length();
        int otherLength = other.length();
        if (stringLength == 0) {
            return otherLength;
        }
        if (otherLength == 0) {
            return stringLength;
        }
        int[] horizontalPreviousCosts = new int[stringLength + 1];
        int[] horizontalCosts = new int[stringLength + 1];
        int i = 0;
        while (i <= stringLength) {
            horizontalPreviousCosts[i] = i;
            ++i;
        }
        int j = 1;
        while (j <= otherLength) {
            char c = other.charAt(j - 1);
            horizontalCosts[0] = j;
            int i2 = 1;
            while (i2 <= stringLength) {
                int cost = string.charAt(i2 - 1) == c ? 0 : 1;
                horizontalCosts[i2] = Math.min(Math.min(horizontalCosts[i2 - 1] + 1, horizontalPreviousCosts[i2] + 1), horizontalPreviousCosts[i2 - 1] + cost);
                ++i2;
            }
            int[] swappingArray = horizontalPreviousCosts;
            horizontalPreviousCosts = horizontalCosts;
            horizontalCosts = swappingArray;
            ++j;
        }
        return horizontalPreviousCosts[stringLength];
    }
}

