/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.tree.walker;

import java.util.Iterator;
import net.anwiba.commons.lang.tree.IItem;
import net.anwiba.commons.lang.tree.ITreeItem;
import net.anwiba.commons.lang.tree.iterator.SortedItemIterator;
import net.anwiba.commons.lang.tree.walker.IItemVisitor;
import net.anwiba.commons.lang.tree.walker.ITreeWalker;

public class TreeWalker<K, V>
implements ITreeWalker<K, V> {
    private final ITreeItem<K, V> first;
    private final ITreeItem<K, V> root;

    public TreeWalker(ITreeItem<K, V> first, ITreeItem<K, V> root) {
        this.first = first;
        this.root = root;
    }

    @Override
    public void walk(IItemVisitor<K, V> handler) {
        ITreeItem<K, V> item = this.root;
        this.walkTo(handler, item);
    }

    private void walkTo(IItemVisitor<K, V> handler, ITreeItem<K, V> item) {
        handler.arrive(item);
        if (item.getLeft() != null) {
            this.walkTo(handler, item.getLeft());
        }
        if (item.getRight() != null) {
            this.walkTo(handler, item.getRight());
        }
        handler.leave(item);
    }

    @Override
    public Iterator<IItem<K, V>> iterator() {
        return new SortedItemIterator<K, V>(this.first);
    }
}

