/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.logging.apache;

import java.util.logging.Level;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.IMessageFactory;
import net.anwiba.commons.logging.LogLevel;
import org.apache.commons.logging.Log;

public final class Logger
implements ILogger {
    private final Log log;

    public Logger(Log log) {
        this.log = log;
    }

    @Override
    public void log(Level level, String message, Throwable throwable) {
        switch (LogLevel.byLevel(level)) {
            case ALL: {
                this.log.trace((Object)message, throwable);
                return;
            }
            case DEBUG: 
            case FINEST: 
            case FINER: {
                this.log.debug((Object)message, throwable);
                return;
            }
            case FINE: 
            case CONFIG: 
            case INFO: {
                this.log.info((Object)message, throwable);
                return;
            }
            case WARNING: {
                this.log.warn((Object)message, throwable);
                return;
            }
            case ERROR: {
                this.log.error((Object)message, throwable);
                return;
            }
            case SEVERE: {
                this.log.fatal((Object)message, throwable);
                return;
            }
            case OFF: {
                return;
            }
        }
        throw new RuntimeException("Unreachable code reached");
    }

    @Override
    public void log(Level level, String message) {
        this.log(level, message, null);
    }

    @Override
    public boolean isLoggable(Level level) {
        switch (LogLevel.byLevel(level)) {
            case ALL: {
                return this.log.isTraceEnabled();
            }
            case DEBUG: 
            case FINEST: 
            case FINER: {
                return this.log.isDebugEnabled();
            }
            case FINE: 
            case CONFIG: 
            case INFO: {
                return this.log.isInfoEnabled();
            }
            case WARNING: {
                return this.log.isWarnEnabled();
            }
            case ERROR: {
                return this.log.isErrorEnabled();
            }
            case SEVERE: {
                return this.log.isFatalEnabled();
            }
            case OFF: {
                return false;
            }
        }
        throw new RuntimeException("Unreachable code reached");
    }

    @Override
    public void log(Level level, IMessageFactory factory) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.log(level, factory.create());
    }
}

