/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.io.filter;

import net.anwiba.commons.utilities.io.filter.IFilteringInputStreamValidator;
import net.anwiba.commons.utilities.queue.IntValueQueue;

public class PatternFilter
implements IFilteringInputStreamValidator {
    private final byte[] pattern;
    private int index = 0;
    private final IntValueQueue queue = new IntValueQueue();

    public PatternFilter(byte[] pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean accept(int value) {
        if (this.pattern[this.index] != value) {
            this.queue.add(value);
            this.index = 0;
            return true;
        }
        if (this.index + 1 == this.pattern.length) {
            this.index = 0;
            this.queue.clear();
            return false;
        }
        ++this.index;
        this.queue.add(value);
        return false;
    }

    @Override
    public IntValueQueue getQueue() {
        return this.queue;
    }
}

