/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.math;

import net.anwiba.commons.utilities.math.Angle;

public final class Complex
extends Number {
    private static final long serialVersionUID = 1L;
    public static final Complex identity = new Complex(0.0, 1.0);
    private final double real;
    private final double imaginary;

    public Complex(double real, double imaginary) {
        this.real = real;
        this.imaginary = imaginary;
    }

    public Complex() {
        this(0.0, 0.0);
    }

    public Complex(double real) {
        this(real, 0.0);
    }

    public Complex(Complex other) {
        this(other.real(), other.imaginary());
    }

    public Complex(Angle phi) {
        this(Angle.cos(phi), Angle.sin(phi));
    }

    public Complex(double real, Angle phi) {
        this(real * Angle.cos(phi), real * Angle.sin(phi));
    }

    public double real() {
        return this.real;
    }

    public double imaginary() {
        return this.imaginary;
    }

    public Complex conjugate() {
        return new Complex(this.real(), -this.imaginary());
    }

    public boolean isReal() {
        return 1.0E-12 > Math.abs(this.imaginary());
    }

    public double magnitude() {
        return Math.sqrt(this.real * this.real + this.imaginary * this.imaginary);
    }

    @Override
    public double doubleValue() {
        if (!this.isReal()) {
            return 0.0;
        }
        return this.real();
    }

    @Override
    public float floatValue() {
        if (!this.isReal()) {
            return 0.0f;
        }
        return (float)this.real();
    }

    @Override
    public long longValue() {
        if (!this.isReal()) {
            return 0L;
        }
        return (long)this.real();
    }

    @Override
    public int intValue() {
        if (!this.isReal()) {
            return 0;
        }
        return (int)this.real();
    }

    public Angle angle() {
        Angle result = new Angle();
        try {
            result = Angle.radian(Math.atan2(this.imaginary, this.real));
        }
        catch (Exception exception) {}
        return result;
    }

    public Complex add(Complex value) {
        return new Complex(this.real + value.real(), this.imaginary + value.imaginary());
    }

    public Complex add(double value) {
        return new Complex(this.real() + value, this.imaginary());
    }

    public Complex subtract(Complex value) {
        return new Complex(this.real - value.real(), this.imaginary - value.imaginary());
    }

    public Complex subtract(double value) {
        return new Complex(this.real() - value, this.imaginary());
    }

    public Complex multiply(Complex factor) {
        return new Complex(this.real * factor.real() - this.imaginary * factor.imaginary(), this.real * factor.imaginary() + this.imaginary * factor.real());
    }

    public Complex multiply(double factor) {
        return new Complex(factor * this.real, factor * this.imaginary);
    }

    public Complex divide(Complex fraction) throws IllegalStateException {
        double magnitude = fraction.magnitude();
        if (Math.abs(magnitude) < 1.0E-12) {
            throw new IllegalStateException("denominator is zero");
        }
        return new Complex((this.real * fraction.real() + this.imaginary * fraction.imaginary()) / (magnitude * magnitude), (this.imaginary * fraction.real() - this.real * fraction.imaginary()) / (magnitude * magnitude));
    }

    public static Complex sin(Complex value) {
        double r = Math.sin(value.real()) * Math.cosh(value.imaginary());
        double i = Math.cos(value.real()) * Math.sinh(value.imaginary());
        return new Complex(r, i);
    }

    public static Complex cos(Complex value) {
        double r = Math.cos(value.real()) * Math.cosh(value.imaginary());
        double i = -Math.sin(value.real()) * Math.sinh(value.imaginary());
        return new Complex(r, i);
    }

    public static Complex tan(Complex value) {
        double denominator = Math.cos(2.0 * value.real()) + Math.cosh(2.0 * value.imaginary());
        double r = Math.sin(2.0 * value.real()) / denominator;
        double i = Math.sinh(2.0 * value.imaginary()) / denominator;
        return new Complex(r, i);
    }

    public static Complex pow(Complex value) {
        double exponent = Math.pow(Math.E, value.real());
        return new Complex(exponent * Math.cos(value.imaginary()), exponent * Math.sin(value.imaginary()));
    }

    public static Complex sinh(Complex value) {
        return new Complex(Complex.pow(value).subtract(Complex.pow(value.multiply(-1.0))).multiply(0.5));
    }

    public static Complex cosh(Complex value) {
        double r = Complex.cosh(value.real()) * Math.cos(value.imaginary());
        double i = Complex.sinh(value.real()) * Math.sin(value.imaginary());
        return new Complex(r, i);
    }

    public static Complex tanh(Complex value) {
        return new Complex(Complex.sinh(value).divide(Complex.cosh(value)));
    }

    public static double tanh(double value) {
        return new Complex(value, 0.0).real();
    }

    public static Complex atan(Complex value) {
        Complex fraction = value.multiply(identity).add(1.0).divide(value.multiply(identity).multiply(-1.0).add(1.0));
        return new Complex(identity.multiply(-0.5).multiply(Complex.ln(fraction)));
    }

    public static double sinh(double value) {
        return 0.5 * (Math.exp(value) - Math.exp(-value));
    }

    public static double cosh(double value) {
        return 0.5 * (Math.exp(value) + Math.exp(-value));
    }

    public static Complex exp(Complex value) {
        double rr = Math.exp(value.real()) * Math.cos(value.imaginary());
        double ii = Math.exp(value.real()) * Math.sin(value.imaginary());
        return new Complex(rr, ii);
    }

    public static Complex ln(Complex value) {
        double rr = Math.log(value.magnitude()) / Math.log(Math.E);
        double ii = value.angle().radian();
        return new Complex(rr, ii);
    }

    public static Complex sqrt(Complex value) {
        double magnitude = Math.sqrt(value.magnitude());
        double phi = value.angle().radian() / 2.0;
        return new Complex(magnitude * Math.cos(phi), magnitude * Math.sin(phi));
    }

    public static Complex asin(Complex value) {
        Complex _value = new Complex(1.0, 0.0).subtract(value.multiply(value));
        _value = Complex.sqrt(_value);
        _value = _value.add(identity.multiply(value));
        _value = identity.multiply(Complex.ln(_value)).multiply(-1.0);
        return _value;
    }

    public static Complex atanh(Complex value) {
        Complex _value = value;
        _value = _value.add(1.0).divide(_value.subtract(1.0)).multiply(-1.0);
        _value = Complex.ln(_value).multiply(0.5);
        return _value;
    }

    public static double atanh(double value) {
        return Complex.atanh(new Complex(value, 0.0)).real();
    }

    public String toString() {
        return new String(String.valueOf(this.real()) + (this.imaginary() < 0.0 ? "-" : "+") + Math.abs(this.imaginary()) + "i");
    }
}

