/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.scale;

import net.anwiba.commons.utilities.scale.IScaleRange;
import net.anwiba.commons.utilities.scale.IScaleValue;
import net.anwiba.commons.utilities.scale.ScaleValue;

public class ScaleRange
implements IScaleRange {
    private static final long serialVersionUID = 1L;
    private final IScaleValue min;
    private final IScaleValue max;
    public static final IScaleValue MIN_VALUE = ScaleValue.NULL_VALUE;
    public static final IScaleValue MAX_VALUE = new ScaleValue(1.0);
    public static final IScaleRange NEUTRAL_RANGE = new ScaleRange(MIN_VALUE, MAX_VALUE);

    public ScaleRange(double min, double max) {
        this(new ScaleValue(min), new ScaleValue(max));
    }

    public ScaleRange(IScaleValue min, IScaleValue max) {
        this.min = this.getMin(min);
        this.max = this.getMax(max);
    }

    private IScaleValue getMin(IScaleValue min) {
        if (min.equals(ScaleValue.NULL_VALUE) || min.getFactor() < MIN_VALUE.getFactor()) {
            return MIN_VALUE;
        }
        return min;
    }

    private IScaleValue getMax(IScaleValue max) {
        if (max.getFactor() > MAX_VALUE.getFactor() || max.equals(ScaleValue.NULL_VALUE)) {
            return MAX_VALUE;
        }
        return max;
    }

    @Override
    public IScaleValue getMin() {
        return this.min;
    }

    @Override
    public IScaleValue getMax() {
        return this.max;
    }

    public int hashCode() {
        int result = 31 + (this.min == null ? 0 : this.min.hashCode());
        return 31 * result + (this.max == null ? 0 : this.max.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IScaleRange)) {
            return false;
        }
        IScaleRange other = (IScaleRange)obj;
        return this.min.equals(other.getMin()) && this.max.equals(other.getMax());
    }

    @Override
    public boolean contains(IScaleValue scaleValue) {
        return this.equals(NEUTRAL_RANGE) || this.min.getFactor() <= scaleValue.getFactor() && scaleValue.getFactor() <= this.max.getFactor();
    }
}

