/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.scale;

import java.text.DecimalFormat;
import net.anwiba.commons.utilities.scale.IScaleValue;

public class ScaleValue
implements Comparable<IScaleValue>,
IScaleValue {
    private static final long serialVersionUID = 1L;
    public static final ScaleValue NULL_VALUE = new ScaleValue(0.0);
    private final double factor;
    private final DecimalFormat decimalFormat = new DecimalFormat("1 : #,##0");

    public ScaleValue(double factor) {
        this.factor = factor;
    }

    @Override
    public double getFactor() {
        return this.factor;
    }

    public int hashCode() {
        if (Double.isInfinite(1.0 / this.factor)) {
            return Double.valueOf(Double.NaN).hashCode();
        }
        return Double.valueOf(this.factor).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IScaleValue)) {
            return super.equals(obj);
        }
        IScaleValue other = (IScaleValue)obj;
        return this.factor == other.getFactor() || Double.isInfinite(1.0 / this.factor) && Double.isInfinite(1.0 / other.getFactor());
    }

    public String toString() {
        if (this.equals(NULL_VALUE)) {
            return "";
        }
        return this.decimalFormat.format(1.0 / this.factor);
    }

    @Override
    public int compareTo(IScaleValue other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.equals(NULL_VALUE)) {
            return -1;
        }
        if (other.equals(NULL_VALUE) || this.factor > other.getFactor()) {
            return 1;
        }
        return -1;
    }
}

