/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.parameter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.utilities.parameter.IParameter;
import net.anwiba.commons.utilities.parameter.IParameters;

public final class Parameters
implements IParameters {
    private static final long serialVersionUID = 655956184779585973L;
    private final List<String> names = new ArrayList<String>();
    private final List<IParameter> parameters = new ArrayList<IParameter>();
    private final Map<String, IParameter> map = new HashMap<String, IParameter>();

    public Parameters(List<IParameter> parameters) {
        this.parameters.addAll(parameters);
        for (IParameter parameter : parameters) {
            this.names.add(parameter.getName());
            this.map.put(parameter.getName(), parameter);
        }
    }

    @Override
    public int getNumberOfParameter() {
        return this.parameters.size();
    }

    @Override
    public IParameter getParameter(int index) {
        return this.parameters.get(index);
    }

    @Override
    public IParameters adapt(int index, IParameter parameter) {
        IParameter[] array = this.parameters.toArray(new IParameter[this.parameters.size()]);
        array[index] = parameter;
        return new Parameters(Arrays.asList(array));
    }

    @Override
    public Iterable<IParameter> parameters() {
        return this.parameters;
    }

    @Override
    public Iterable<String> getNames() {
        return this.names;
    }

    @Override
    public String getValue(String name) throws RuntimeException {
        if (!this.map.containsKey(name)) {
            return null;
        }
        return this.map.get(name).getValue();
    }
}

