/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.crypto;

import net.anwiba.crypto.CodingException;
import net.anwiba.crypto.CryptoUtilities;
import net.anwiba.crypto.IPassword;
import net.anwiba.crypto.IPasswordCoder;

public class PasswordCoder
implements IPasswordCoder {
    private final byte[] key;

    public PasswordCoder(byte[] key) {
        this.key = key;
    }

    @Override
    public String decode(String password) throws CodingException {
        return new String(CryptoUtilities.getDecodedBytes(this.key, password.getBytes()));
    }

    @Override
    public String decode(IPassword password) throws CodingException {
        if (!password.isEncrypted()) {
            return password.getValue();
        }
        return this.decode(password.getValue());
    }

    @Override
    public String encode(String password) throws CodingException {
        byte[] encodedBytes = CryptoUtilities.getEncodedBytes(this.key, password.getBytes());
        return new String(encodedBytes);
    }
}

