/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.crypto;

import net.anwiba.commons.crypto.CodingException;
import net.anwiba.commons.crypto.CryptoUtilities;
import net.anwiba.commons.crypto.IPassword;
import net.anwiba.commons.crypto.IPasswordCoder;

public class PasswordCoder
implements IPasswordCoder {
    private final byte[] key;

    public PasswordCoder(byte[] key) {
        this.key = key;
    }

    @Override
    public String decode(String password) throws CodingException {
        return new String(CryptoUtilities.getDecodedBytes(this.key, password.getBytes()));
    }

    @Override
    public String decode(IPassword password) throws CodingException {
        if (password == null) {
            return null;
        }
        if (!password.isEncrypted()) {
            return password.getValue();
        }
        return this.decode(password.getValue());
    }

    @Override
    public String encode(String password) throws CodingException {
        byte[] encodedBytes = CryptoUtilities.getEncodedBytes(this.key, password.getBytes());
        return new String(encodedBytes);
    }
}

