/*
 * #%L
 *
 * %%
 * Copyright (C) 2007 - 2018 Andreas W. Bartels
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-2.1.html>.
 * #L%
 */
package net.anwiba.commons.datasource.history;

import java.time.Duration;
import java.time.LocalDateTime;

import net.anwiba.commons.datasource.resource.IResourceDescription;
import net.anwiba.commons.utilities.time.UserDateTimeUtilities;

public class DatasourceEventLogger implements IDatasourceEventLogger {

  private final IDatasourceEventStorage storage;

  public DatasourceEventLogger(final IDatasourceEventStorage storage) {
    this.storage = storage;
  }

  @Override
  public void log(
      final String kind,
      final IResourceDescription sourceResourceDescription,
      final IResourceDescription targetResourceDescription,
      final String join,
      final String condition,
      final Long numberOfRows,
      final Duration duration) {

    final LocalDateTime date = UserDateTimeUtilities.now();
    this.storage.save(
        new DatasourceEvent(
            kind,
            targetResourceDescription,
            sourceResourceDescription,
            date,
            duration,
            join,
            condition,
            numberOfRows));
  }

}
