/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.datasource.connection;

import java.net.URI;
import net.anwiba.commons.datasource.DataSourceType;
import net.anwiba.commons.datasource.connection.AbstractConnectionDescription;
import net.anwiba.commons.datasource.connection.IConnectionDescription;
import net.anwiba.commons.datasource.connection.IFileConnectionDescription;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.ResourceReferenceFactory;

public class FileConnectionDescription
extends AbstractConnectionDescription
implements IFileConnectionDescription {
    private static final long serialVersionUID = -931879424583598936L;
    private final URI uri;

    public FileConnectionDescription(URI uri) {
        super(DataSourceType.FILE);
        this.uri = uri;
    }

    @Override
    public IResourceReference getResourceReference() {
        return new ResourceReferenceFactory().create(this.uri);
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public String getUrl() {
        return this.uri.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IConnectionDescription)) {
            return false;
        }
        IConnectionDescription other = (IConnectionDescription)obj;
        return ObjectUtilities.equals((Object)this.getURI(), (Object)other.getURI()) && ObjectUtilities.equals((Object)((Object)this.getDataSourceType()), (Object)((Object)other.getDataSourceType()));
    }

    public int hashCode() {
        return ObjectUtilities.hashCode((Object[])new Object[]{this.getURI()});
    }

    @Override
    public DataSourceType getDataSourceType() {
        return DataSourceType.FILE;
    }

    @Override
    public String getFormat() {
        return "File";
    }
}

