/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.datasource.connection;

import java.io.File;
import java.net.URI;
import net.anwiba.commons.datasource.DataSourceType;
import net.anwiba.commons.datasource.connection.AbstractConnectionDescription;
import net.anwiba.commons.datasource.connection.IFileSystemConnectionDescription;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.ResourceReferenceFactory;

public class FileSystemConnectionDescription
extends AbstractConnectionDescription
implements IFileSystemConnectionDescription {
    private static final long serialVersionUID = 5088280043009120362L;
    private final File file;

    public FileSystemConnectionDescription(File file) {
        super(DataSourceType.FILE);
        Ensure.ensureArgumentNotNull((Object)file);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("file isn't a directory " + file.getAbsolutePath());
        }
        this.file = file;
    }

    @Override
    public IResourceReference getResourceReference() {
        return new ResourceReferenceFactory().create(this.file);
    }

    @Override
    public String getUrl() {
        return this.getURI().toASCIIString();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public URI getURI() {
        return this.getFile().toURI();
    }

    public String toString() {
        return this.getFile().getPath();
    }

    @Override
    public String getFormat() {
        return "Folder";
    }

    public int hashCode() {
        return 31 * (this.file == null ? 0 : this.file.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IFileSystemConnectionDescription)) {
            return false;
        }
        IFileSystemConnectionDescription other = (IFileSystemConnectionDescription)object;
        return ObjectUtilities.equals((Object)this.getURI(), (Object)other.getURI()) && ObjectUtilities.equals((Object)((Object)this.getDataSourceType()), (Object)((Object)other.getDataSourceType()));
    }
}

