/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.datasource.connection;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import net.anwiba.commons.datasource.DataSourceType;
import net.anwiba.commons.datasource.DataSourceVersion;
import net.anwiba.commons.datasource.connection.IMemoryConnectionDescription;
import net.anwiba.commons.lang.optional.Optional;

public class MemoryConnectionDescription
implements IMemoryConnectionDescription {
    private final ZonedDateTime timeStamp;
    private static final long serialVersionUID = 1L;
    private final Object content;
    private final String mimeType;

    public MemoryConnectionDescription(Serializable content) {
        this(content, null);
    }

    public MemoryConnectionDescription(Serializable content, ZonedDateTime timeStamp) {
        this(content, MessageFormat.format("{0};class=\"{1}\"", "application/x-java-jvm-local-objectref", Optional.of((Object)content).convert(c -> c.getClass()).getOr(() -> Object.class)), timeStamp);
    }

    public MemoryConnectionDescription(Serializable content, String mimeType, ZonedDateTime timeStamp) {
        this.content = content;
        this.mimeType = mimeType;
        this.timeStamp = (ZonedDateTime)Optional.of((Object)timeStamp).getOr(() -> ZonedDateTime.now());
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public <T> T getContent() {
        return (T)this.content;
    }

    @Override
    public Class<?> getContentClass() {
        return (Class)Optional.of((Object)this.content).convert(c -> c.getClass()).getOr(() -> Object.class);
    }

    @Override
    public URI getURI() {
        try {
            return new URI(this.getUrl());
        }
        catch (URISyntaxException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String getUrl() {
        return "memory:/" + this.timeStamp.format(DateTimeFormatter.ISO_INSTANT);
    }

    @Override
    public ZonedDateTime getTimeStamp() {
        return this.timeStamp;
    }

    public boolean equals(Object obj) {
        return obj instanceof IMemoryConnectionDescription;
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    @Override
    public DataSourceType getDataSourceType() {
        return DataSourceType.MEMORY;
    }

    @Override
    public String getFormat() {
        return this.getDataSourceType().name();
    }

    @Override
    public DataSourceVersion getVersion() {
        return new DataSourceVersion(1, 0, null);
    }
}

