/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.datasource.resource;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import net.anwiba.commons.datasource.connection.FileConnectionDescription;
import net.anwiba.commons.datasource.connection.HttpConnectionDescription;
import net.anwiba.commons.datasource.connection.IConnectionDescription;
import net.anwiba.commons.datasource.connection.MemoryConnectionDescription;
import net.anwiba.commons.datasource.resource.IResourceDescription;
import net.anwiba.commons.datasource.resource.StringToUrlConverter;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.functional.ConversionException;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.reference.FileResourceReference;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceVisitor;
import net.anwiba.commons.reference.MemoryResourceReference;
import net.anwiba.commons.reference.PathResourceReference;
import net.anwiba.commons.reference.ResourceReferenceFactory;
import net.anwiba.commons.reference.UriResourceReference;
import net.anwiba.commons.reference.UrlResourceReference;
import net.anwiba.commons.utilities.io.url.IUrl;

public class ResourceDescription
implements IResourceDescription {
    private static final long serialVersionUID = 1L;
    private final IConnectionDescription connectionDescription;

    public static ResourceDescription of(String string) throws CreationException {
        return ResourceDescription.of(new ResourceReferenceFactory().create(string));
    }

    public static ResourceDescription of(IResourceReference resourceReference) throws CreationException {
        IConnectionDescription connectionDescription = (IConnectionDescription)resourceReference.accept((IResourceReferenceVisitor)new IResourceReferenceVisitor<IConnectionDescription, CreationException>(){

            public IConnectionDescription visitFileResource(FileResourceReference fileResourceReference) throws RuntimeException {
                return new FileConnectionDescription(fileResourceReference.getFile().toURI());
            }

            public IConnectionDescription visitUrlResource(UrlResourceReference urlResourceReference) throws CreationException {
                URL inUrl = urlResourceReference.getUrl();
                if ("file".equals(inUrl.getProtocol())) {
                    return new FileConnectionDescription(new File(inUrl.getPath()).toURI());
                }
                try {
                    IUrl url = new StringToUrlConverter().convert(inUrl.toString());
                    if (url == null) {
                        throw new CreationException("Couldn't create resource description for url '" + inUrl.toString() + "'");
                    }
                    return new HttpConnectionDescription(url.getHostname(), url.getPort(), url.getPathString(), url.getUserName(), url.getPassword(), url.getQuery(), Optional.of((Object)url.getScheme()).accept(s -> !s.isEmpty()).convert(s -> (String)s.get(s.size() - 1)).accept(p -> "https".equalsIgnoreCase((String)p)).isAccepted());
                }
                catch (ConversionException exception) {
                    throw new CreationException("Couldn't create resource description for url '" + inUrl.toString() + "'", (Throwable)exception);
                }
            }

            public IConnectionDescription visitUriResource(UriResourceReference uriResourceReference) throws RuntimeException, CreationException {
                URI uri = uriResourceReference.getUri();
                if ("file".equals(uri.getScheme())) {
                    return new FileConnectionDescription(new File(uri.getPath()).toURI());
                }
                try {
                    IUrl url = new StringToUrlConverter().convert(uri.toString());
                    if (url == null) {
                        throw new CreationException("Couldn't create resource description for url '" + uri.toString() + "'");
                    }
                    return new HttpConnectionDescription(url.getHostname(), url.getPort(), url.getPathString(), url.getUserName(), url.getPassword(), url.getQuery(), Optional.of((Object)url.getScheme()).accept(s -> !s.isEmpty()).convert(s -> (String)s.get(s.size() - 1)).accept(p -> "https".equalsIgnoreCase((String)p)).isAccepted());
                }
                catch (ConversionException exception) {
                    throw new CreationException("Couldn't create resource description for url '" + uri.toString() + "'", (Throwable)exception);
                }
            }

            public IConnectionDescription visitMemoryResource(MemoryResourceReference memoryResourceReference) throws RuntimeException {
                return new MemoryConnectionDescription((Serializable)memoryResourceReference, memoryResourceReference.getMimeType(), memoryResourceReference.getTimeStamp());
            }

            public IConnectionDescription visitPathResource(PathResourceReference pathResourceReference) throws RuntimeException {
                return new FileConnectionDescription(pathResourceReference.getPath().toFile().toURI());
            }
        });
        return new ResourceDescription(connectionDescription);
    }

    ResourceDescription(IConnectionDescription connectionDescription) {
        this.connectionDescription = connectionDescription;
    }

    @Override
    public IConnectionDescription getConnectionDescription() {
        return this.connectionDescription;
    }

    @Override
    public String getUrl() {
        return this.connectionDescription.getUrl();
    }
}

