/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.datasource.connection;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Objects;
import net.anwiba.commons.datasource.DataSourceType;
import net.anwiba.commons.datasource.connection.AbstractConnectionDescription;
import net.anwiba.commons.datasource.connection.IHttpConnectionDescription;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.lang.parameter.IParameter;
import net.anwiba.commons.lang.parameter.IParameters;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.ResourceReferenceFactory;
import net.anwiba.commons.reference.url.Authentication;
import net.anwiba.commons.reference.url.IAuthentication;
import net.anwiba.commons.utilities.property.IProperties;
import net.anwiba.commons.utilities.string.StringUtilities;

public abstract class AbstractHttpConnectionDescription
extends AbstractConnectionDescription
implements IHttpConnectionDescription {
    private static final long serialVersionUID = 1L;
    private final String host;
    private final int port;
    private final String path;
    private final String userName;
    private final String password;
    private final boolean sslEnabled;
    private final IParameters parameters;
    private final int hashCode;

    public AbstractHttpConnectionDescription(String host, int port, String path, String userName, String password, IParameters parameters, boolean sslEnabled, IProperties properties) {
        super(DataSourceType.SERVICE, properties);
        this.host = host;
        this.port = port;
        this.path = path;
        this.userName = userName;
        this.password = password;
        this.parameters = parameters;
        this.sslEnabled = sslEnabled;
        this.hashCode = this.createHashCode();
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public IParameters getParameters() {
        return this.parameters;
    }

    @Override
    public IResourceReference getResourceReference() {
        try {
            return new ResourceReferenceFactory().create(this.getUrl());
        }
        catch (CreationException exception) {
            throw new UnreachableCodeReachedException((Throwable)exception);
        }
    }

    @Override
    public URI getURI() {
        try {
            return new URI(this.getUrlString());
        }
        catch (URISyntaxException exception) {
            throw new UnreachableCodeReachedException((Throwable)exception);
        }
    }

    @Override
    public String getUrl() {
        Object[] objectArray = new Object[4];
        objectArray[0] = this.sslEnabled ? "https" : "http";
        objectArray[1] = this.host;
        Object object = objectArray[2] = this.port <= 0 ? "" : ":" + this.port;
        objectArray[3] = this.path == null ? "/" : (this.path.startsWith("/") ? this.path : "/" + this.path);
        return MessageFormat.format("{0}://{1}{2}{3}", objectArray);
    }

    @Override
    public String getUrlString() {
        Object[] objectArray = new Object[5];
        objectArray[0] = this.sslEnabled ? "https" : "http";
        objectArray[1] = this.host;
        Object object = objectArray[2] = this.port <= 0 ? "" : ":" + this.port;
        objectArray[3] = this.path == null ? "/" : (this.path.startsWith("/") ? this.path : "/" + this.path);
        objectArray[4] = this.getQueryString();
        return MessageFormat.format("{0}://{1}{2}{3}{4}", objectArray);
    }

    private String getQueryString() {
        int indexOfQueryStartSymbol;
        if (this.parameters.getNumberOfParameter() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int n = indexOfQueryStartSymbol = this.path == null ? -1 : this.path.indexOf("?");
        if (indexOfQueryStartSymbol == -1) {
            builder.append("?");
        } else if (indexOfQueryStartSymbol < this.path.length() - 1) {
            builder.append("&");
        }
        boolean flag = false;
        for (IParameter parameter : this.parameters.parameters()) {
            if (flag) {
                builder.append("&");
            }
            builder.append(parameter.getName());
            builder.append("=");
            builder.append(parameter.getValue());
            flag = true;
        }
        return builder.toString();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    protected int createHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.toUpperCase().hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.toUpperCase().hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.toUpperCase().hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.sslEnabled ? 1231 : 1237);
        result = 31 * result + (this.userName == null ? 0 : this.userName.toUpperCase().hashCode());
        return result;
    }

    @Override
    public IAuthentication getAuthentication() {
        return new Authentication(this.userName, this.password);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IHttpConnectionDescription)) {
            return false;
        }
        IHttpConnectionDescription other = (IHttpConnectionDescription)obj;
        return Objects.equals((Object)this.getDataSourceType(), (Object)other.getDataSourceType()) && this.port == other.getPort() && StringUtilities.trimedAndUpperCaseEquals((String)this.host, (String)other.getHost()) && StringUtilities.trimedAndUpperCaseEquals((String)this.path, (String)other.getPath()) && StringUtilities.trimedAndUpperCaseEquals((String)this.userName, (String)other.getUserName()) && StringUtilities.trimedAndUpperCaseEquals((String)this.password, (String)other.getPassword()) && Objects.equals(this.getParameters(), other.getParameters()) && this.isSslEnabled() == other.isSslEnabled();
    }

    @Override
    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public String toString(String name) {
        if (this.getUserName() != null) {
            Object[] objectArray = new Object[6];
            objectArray[0] = name;
            objectArray[1] = this.getUserName();
            objectArray[2] = this.host;
            Object object = objectArray[3] = this.port <= 0 ? "" : ":" + this.port;
            objectArray[4] = this.path == null ? "/" : (this.path.startsWith("/") ? this.path : "/" + this.path);
            objectArray[5] = this.getQueryString();
            return MessageFormat.format("{0}({1}@{2}{3}{4}{5})", objectArray);
        }
        Object[] objectArray = new Object[5];
        objectArray[0] = name;
        objectArray[1] = this.host;
        Object object = objectArray[2] = this.port <= 0 ? "" : ":" + this.port;
        objectArray[3] = this.path == null ? "/" : (this.path.startsWith("/") ? this.path : "/" + this.path);
        objectArray[4] = this.getQueryString();
        return MessageFormat.format("{0}({1}{2}{3}{4})", objectArray);
    }
}

