/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.datasource.connection;

import java.net.URI;
import java.net.URISyntaxException;
import net.anwiba.commons.datasource.DataSourceType;
import net.anwiba.commons.datasource.connection.AbstractConnectionDescription;
import net.anwiba.commons.datasource.connection.IConnectionDescription;
import net.anwiba.commons.datasource.connection.IFileConnectionDescription;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.ResourceReferenceUtilities;
import net.anwiba.commons.reference.url.IAuthentication;
import net.anwiba.commons.utilities.property.Properties;

public class FileConnectionDescription
extends AbstractConnectionDescription
implements IFileConnectionDescription {
    private static final long serialVersionUID = -931879424583598936L;
    private final IResourceReference reference;

    public FileConnectionDescription(IResourceReference reference) {
        super(DataSourceType.FILE, Properties.empty());
        this.reference = reference;
    }

    @Override
    public IResourceReference getResourceReference() {
        return this.reference;
    }

    @Override
    public FileConnectionDescription adapt(IAuthentication authentication) {
        return new FileConnectionDescription(this.reference);
    }

    @Override
    public URI getURI() {
        try {
            return ResourceReferenceUtilities.getUri((IResourceReference)this.reference);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public String getUrl() {
        return this.getURI().toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IConnectionDescription)) {
            return false;
        }
        IConnectionDescription other = (IConnectionDescription)obj;
        return ObjectUtilities.equals((Object)this.getURI(), (Object)other.getURI()) && ObjectUtilities.equals((Object)((Object)this.getDataSourceType()), (Object)((Object)other.getDataSourceType()));
    }

    @Override
    public int hashCode() {
        return ObjectUtilities.hashCode((Object[])new Object[]{this.getURI()});
    }

    @Override
    public DataSourceType getDataSourceType() {
        return DataSourceType.FILE;
    }

    @Override
    public String getFormat() {
        return "File";
    }

    @Override
    public IAuthentication getAuthentication() {
        return null;
    }
}

