/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.datasource.connection;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import net.anwiba.commons.datasource.DataSourceType;
import net.anwiba.commons.datasource.connection.AbstractConnectionDescription;
import net.anwiba.commons.datasource.connection.IFileSystemConnectionDescription;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.ResourceReferenceFactory;
import net.anwiba.commons.reference.url.IAuthentication;
import net.anwiba.commons.reference.utilities.PathUtilities;
import net.anwiba.commons.utilities.property.Properties;

public class FileSystemConnectionDescription
extends AbstractConnectionDescription
implements IFileSystemConnectionDescription {
    private static final long serialVersionUID = 5088280043009120362L;
    private transient Path rootPath;
    private transient Path homePath;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.rootPath.toUri());
        out.defaultWriteObject();
        out.writeObject(this.homePath.toUri());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        URI uri = (URI)in.readObject();
        this.rootPath = PathUtilities.create((URI)uri);
        uri = (URI)in.readObject();
        this.homePath = PathUtilities.create((URI)uri);
    }

    public FileSystemConnectionDescription(File file) {
        this(file.toPath().getRoot(), file.toPath().toAbsolutePath());
    }

    public FileSystemConnectionDescription(Path root, Path homePath) {
        super(DataSourceType.FILESYSTEM, Properties.empty());
        Ensure.ensureArgumentNotNull((Object)root);
        Ensure.ensureArgumentNotNull((Object)homePath);
        this.rootPath = root;
        this.homePath = homePath;
        if (!Files.isDirectory(homePath, new LinkOption[0])) {
            throw new IllegalArgumentException("homepath isn't a directory " + homePath.toAbsolutePath().toString());
        }
    }

    @Override
    public FileSystemConnectionDescription adapt(IAuthentication authentication) {
        return new FileSystemConnectionDescription(this.rootPath, this.homePath);
    }

    @Override
    public IAuthentication getAuthentication() {
        return null;
    }

    @Override
    public IResourceReference getResourceReference() {
        return new ResourceReferenceFactory().create(this.homePath);
    }

    @Override
    public String getUrl() {
        return this.getURI().toASCIIString();
    }

    @Override
    public URI getURI() {
        if (Objects.equals(this.getScheme(), "file")) {
            URI uri = this.homePath.toAbsolutePath().toFile().toURI();
            return uri;
        }
        return URI.create(this.getScheme() + ":" + this.rootPath.toString() + "!" + this.homePath.toAbsolutePath().toString());
    }

    public String toString() {
        if (Objects.equals(this.getScheme(), "file")) {
            return this.homePath.toAbsolutePath().toString();
        }
        return this.homePath.toUri().toString();
    }

    @Override
    public String getFormat() {
        return "Filesystem";
    }

    @Override
    public int hashCode() {
        return 31 * (this.rootPath == null ? 0 : this.rootPath.hashCode()) + (this.homePath == null ? 0 : this.homePath.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IFileSystemConnectionDescription)) {
            return false;
        }
        IFileSystemConnectionDescription other = (IFileSystemConnectionDescription)object;
        return ObjectUtilities.equals((Object)((Object)this.getDataSourceType()), (Object)((Object)other.getDataSourceType())) && ObjectUtilities.equals((Object)this.getHomePath(), (Object)other.getHomePath()) && ObjectUtilities.equals((Object)this.getRootPath(), (Object)other.getRootPath());
    }

    @Override
    public Path getRootPath() {
        return this.rootPath;
    }

    @Override
    public Path getHomePath() {
        return this.homePath;
    }

    @Override
    public String getScheme() {
        return this.homePath.getFileSystem().provider().getScheme();
    }
}

