/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.datasource.connection;

import java.net.URI;
import java.net.URL;
import net.anwiba.commons.datasource.connection.AbstractHttpConnectionDescription;
import net.anwiba.commons.datasource.connection.IHttpConnectionDescription;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.parameter.IParameters;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.ResourceReferenceFactory;
import net.anwiba.commons.reference.url.IAuthentication;
import net.anwiba.commons.reference.url.IUrl;
import net.anwiba.commons.reference.url.parser.UrlParser;
import net.anwiba.commons.utilities.property.Properties;

public class HttpConnectionDescription
extends AbstractHttpConnectionDescription {
    private static final long serialVersionUID = 1L;

    public HttpConnectionDescription(String host, int port, String path, String userName, String password, IParameters parameters, boolean sslEnabled) {
        super(host, port, path, userName, password, parameters, sslEnabled, Properties.empty());
    }

    @Override
    public HttpConnectionDescription adapt(IAuthentication authentication) {
        return new HttpConnectionDescription(this.getHost(), this.getPort(), this.getPath(), authentication.getUsername(), authentication.getPassword(), this.getParameters(), this.isSslEnabled());
    }

    @Override
    public IResourceReference getResourceReference() {
        return new ResourceReferenceFactory().create(this.getURI());
    }

    public String toString() {
        return this.toString(this.getFormat());
    }

    @Override
    public String getFormat() {
        return "Web";
    }

    public static IHttpConnectionDescription of(URI uri) {
        try {
            IUrl url = new UrlParser().parse(uri.toString());
            return new HttpConnectionDescription(url.getHostname(), url.getPort(), url.getPathString(), url.getUserName(), url.getPassword(), url.getQuery(), Optional.of((Object)url.getScheme()).accept(s -> !s.isEmpty()).convert(s -> (String)s.get(s.size() - 1)).accept(p -> "https".equalsIgnoreCase((String)p)).isAccepted());
        }
        catch (CreationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static IHttpConnectionDescription of(URL uri) {
        try {
            IUrl url = new UrlParser().parse(uri.toString());
            return new HttpConnectionDescription(url.getHostname(), url.getPort(), url.getPathString(), url.getUserName(), url.getPassword(), url.getQuery(), Optional.of((Object)url.getScheme()).accept(s -> !s.isEmpty()).convert(s -> (String)s.get(s.size() - 1)).accept(p -> "https".equalsIgnoreCase((String)p)).isAccepted());
        }
        catch (CreationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

