/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.datasource.connection;

import java.io.Serializable;
import java.net.URI;
import java.util.Set;
import net.anwiba.commons.datasource.DataSourceType;
import net.anwiba.commons.reference.url.IAuthentication;
import net.anwiba.commons.utilities.property.IProperties;
import net.anwiba.commons.utilities.property.Properties;
import net.anwiba.commons.utilities.string.StringUtilities;

public interface IConnectionDescription
extends Serializable {
    public static final Set<String> reserved = Set.of("schema", "table", "column");

    public IConnectionDescription adapt(IAuthentication var1);

    public IAuthentication getAuthentication();

    public String getUrl();

    public URI getURI();

    public String getFormat();

    public DataSourceType getDataSourceType();

    default public IProperties getProperties() {
        return Properties.empty();
    }

    public static boolean isProperty(String name, String value) {
        if (StringUtilities.isNullOrTrimmedEmpty((String)name) || StringUtilities.isNullOrTrimmedEmpty((String)value)) {
            return false;
        }
        return !reserved.contains(name.toLowerCase());
    }
}

