/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.datasource.constaint;

import java.time.LocalDateTime;
import java.util.List;
import net.anwiba.commons.datasource.constaint.ILicense;
import net.anwiba.commons.datasource.constaint.IResourceConstraint;
import net.anwiba.commons.datasource.constaint.License;
import net.anwiba.commons.datasource.resource.IResourceDescription;
import net.anwiba.commons.utilities.time.UserDateTimeUtilities;

public class ResourceConstraint
implements IResourceConstraint {
    private final IResourceDescription resourceDescription;
    private final ILicense constraint;
    private final LocalDateTime registered;
    private final String source;
    private final String usagePolicy;

    public ResourceConstraint(IResourceDescription resourceDescription, ILicense constraint, String source) {
        this(resourceDescription, constraint, source, null, UserDateTimeUtilities.now().toLocalDateTime());
    }

    public ResourceConstraint(IResourceDescription resourceDescription, ILicense constraint, String source, String usagePolicy, LocalDateTime registered) {
        this.resourceDescription = resourceDescription;
        this.constraint = constraint;
        this.source = source;
        this.usagePolicy = usagePolicy;
        this.registered = registered;
    }

    @Override
    public ILicense getLicense() {
        return this.constraint;
    }

    @Override
    public IResourceDescription getResourceDescription() {
        return this.resourceDescription;
    }

    @Override
    public String getMaintainer() {
        return this.source;
    }

    @Override
    public String getUsagePolicy() {
        return this.usagePolicy;
    }

    @Override
    public LocalDateTime getRegistered() {
        return this.registered;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constraint == null ? 0 : this.constraint.hashCode());
        result = 31 * result + (this.resourceDescription == null ? 0 : this.resourceDescription.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceConstraint other = (ResourceConstraint)obj;
        if (this.constraint == null ? other.constraint != null : !this.constraint.equals(other.constraint)) {
            return false;
        }
        if (this.resourceDescription == null ? other.resourceDescription != null : !this.resourceDescription.equals(other.resourceDescription)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public static IResourceConstraint of(IResourceDescription resource, String identifier, String name, String reference, List<String> attributes, String source, String usagePolicy, LocalDateTime registered) {
        return new ResourceConstraint(resource, License.of(identifier, name, reference, attributes), source, usagePolicy, registered);
    }

    public static IResourceConstraint of(IResourceDescription resource, ILicense license) {
        return new ResourceConstraint(resource, license, null, null, UserDateTimeUtilities.now().toLocalDateTime());
    }

    public static IResourceConstraint of(IResourceDescription resource, ILicense license, String maintainer) {
        return new ResourceConstraint(resource, license, maintainer, null, UserDateTimeUtilities.now().toLocalDateTime());
    }

    public static IResourceConstraint of(IResourceDescription resource, ILicense license, String maintainer, String usagePolicy) {
        return new ResourceConstraint(resource, license, maintainer, usagePolicy, UserDateTimeUtilities.now().toLocalDateTime());
    }
}

