/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.datasource.constaint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import net.anwiba.commons.datasource.constaint.IRegisterableResourceConstraintProvider;
import net.anwiba.commons.datasource.constaint.IResourceConstraint;
import net.anwiba.commons.datasource.constaint.IResourceConstraintProvider;
import net.anwiba.commons.datasource.constaint.IResourceConstraintStorage;
import net.anwiba.commons.datasource.resource.IResourceDescription;
import net.anwiba.commons.datasource.resource.ResourceDescription;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.lang.stream.Streams;

public class ResourceConstraintProvider
implements IResourceConstraintProvider {
    private final IResourceConstraintStorage resourceConstraintStorage;
    final Collection<IRegisterableResourceConstraintProvider> providers = new ArrayList<IRegisterableResourceConstraintProvider>();

    public ResourceConstraintProvider(Collection<IRegisterableResourceConstraintProvider> providers, IResourceConstraintStorage resourceConstraintStorage) {
        this.resourceConstraintStorage = resourceConstraintStorage;
        this.providers.addAll(providers);
    }

    @Override
    public IObjectList<IResourceConstraint> getConstaints(IResourceDescription description) {
        LinkedHashSet constraints = new LinkedHashSet();
        constraints.addAll(this.resourceConstraintStorage.read(description).toCollection());
        Streams.of(this.providers).filter(p -> p.isApplicable(description)).foreach(p -> constraints.addAll(p.getConstaints(description).toCollection()));
        if (constraints.isEmpty() && !Objects.equals(description.getUrl(), ResourceDescription.of(description.getConnectionDescription()).getUrl())) {
            return this.getConstaints(ResourceDescription.of(description.getConnectionDescription()));
        }
        return new ObjectList(constraints);
    }
}

