/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.datasource.history;

import java.time.Duration;
import java.time.LocalDateTime;
import net.anwiba.commons.datasource.constaint.IResourceConstraint;
import net.anwiba.commons.datasource.constaint.IResourceConstraintProvider;
import net.anwiba.commons.datasource.constaint.IResourceConstraintStorage;
import net.anwiba.commons.datasource.constaint.ResourceConstraint;
import net.anwiba.commons.datasource.history.DatasourceEvent;
import net.anwiba.commons.datasource.history.IDatasourceEventLogger;
import net.anwiba.commons.datasource.history.IDatasourceEventStorage;
import net.anwiba.commons.datasource.resource.IResourceDescription;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.IStream;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.message.IMessageCollector;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.commons.thread.process.AbstractProcess;
import net.anwiba.commons.thread.process.IProcess;
import net.anwiba.commons.thread.process.IProcessIdentfier;
import net.anwiba.commons.thread.process.IProcessManager;
import net.anwiba.commons.utilities.time.UserDateTimeUtilities;

public class DatasourceEventLogger
implements IDatasourceEventLogger {
    private static ILogger logger = Logging.getLogger(DatasourceEventLogger.class);
    private final IDatasourceEventStorage eventStorage;
    private final IResourceConstraintStorage constraintStorage;
    private final IResourceConstraintProvider constraintProvider;
    private final IProcessManager processManager;

    public DatasourceEventLogger(IProcessManager processManager, IDatasourceEventStorage eventStorage, IResourceConstraintProvider constraintProvider, IResourceConstraintStorage constraintStorage) {
        this.processManager = processManager;
        this.eventStorage = eventStorage;
        this.constraintProvider = constraintProvider;
        this.constraintStorage = constraintStorage;
    }

    @Override
    public void log(final String kind, final IResourceDescription sourceResourceDescription, final IResourceDescription targetResourceDescription, final String join, final String condition, final Long numberOfRows, final Duration duration) {
        final LocalDateTime date = UserDateTimeUtilities.now().toLocalDateTime();
        this.processManager.execute((IProcess)new AbstractProcess("AUDIT_LOGGING", "Audit logging", false){

            public void execute(IMessageCollector processMonitor, ICanceler canceler, IProcessIdentfier processIdentfier) throws CanceledException {
                logger.log(ILevel.DEBUG, kind + ": " + targetResourceDescription.getUrl());
                DatasourceEventLogger.this.eventStorage.save(new DatasourceEvent(kind, targetResourceDescription, sourceResourceDescription, date, duration, join, condition, numberOfRows));
                Optional.of((Object)sourceResourceDescription).consume(d -> this.addConstraints(targetResourceDescription, (IResourceDescription)d));
            }

            private IStream<IResourceConstraint, RuntimeException> addConstraints(IResourceDescription target, IResourceDescription source) {
                IObjectList<IResourceConstraint> constaints = DatasourceEventLogger.this.constraintProvider.getConstaints(source);
                return constaints.stream().convert(c -> ResourceConstraint.of(target, c.getLicense(), c.getMaintainer())).foreach(c -> this.save((IResourceConstraint)c));
            }

            private void save(IResourceConstraint c) {
                DatasourceEventLogger.this.constraintStorage.save(c);
            }
        });
    }
}

