/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.datasource.resource;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.time.Clock;
import java.time.ZonedDateTime;
import net.anwiba.commons.datasource.connection.FileConnectionDescription;
import net.anwiba.commons.datasource.connection.HttpConnectionDescription;
import net.anwiba.commons.datasource.connection.IConnectionDescription;
import net.anwiba.commons.datasource.connection.MemoryConnectionDescription;
import net.anwiba.commons.datasource.resource.IResourceDescription;
import net.anwiba.commons.datasource.resource.StringToUrlConverter;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.functional.ConversionException;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.reference.FileResourceReference;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceVisitor;
import net.anwiba.commons.reference.MemoryResourceReference;
import net.anwiba.commons.reference.PathResourceReference;
import net.anwiba.commons.reference.ResourceReferenceFactory;
import net.anwiba.commons.reference.URIResourceReference;
import net.anwiba.commons.reference.URLResourceReference;
import net.anwiba.commons.reference.UniformResourceLocatorReference;
import net.anwiba.commons.reference.url.IAuthentication;
import net.anwiba.commons.reference.url.IUrl;

public class ResourceDescription
implements IResourceDescription {
    private static final long serialVersionUID = 1L;
    private final IConnectionDescription connectionDescription;

    public static ResourceDescription of(String string) throws CreationException {
        return ResourceDescription.of(new ResourceReferenceFactory().create(string));
    }

    public static ResourceDescription of(IResourceReference resourceReference) throws CreationException {
        IConnectionDescription connectionDescription = (IConnectionDescription)resourceReference.accept((IResourceReferenceVisitor)new IResourceReferenceVisitor<IConnectionDescription, CreationException>(){

            public IConnectionDescription visitUrlResource(UniformResourceLocatorReference urlResourceReference) throws RuntimeException {
                throw new UnsupportedOperationException();
            }

            public IConnectionDescription visitFileResource(FileResourceReference fileResourceReference) throws RuntimeException {
                return new FileConnectionDescription((IResourceReference)fileResourceReference);
            }

            public IConnectionDescription visitURLResource(URLResourceReference urlResourceReference) throws CreationException {
                URL inUrl = urlResourceReference.getUrl();
                if ("file".equals(inUrl.getProtocol())) {
                    return new FileConnectionDescription(new ResourceReferenceFactory().create(new File(inUrl.getPath())));
                }
                try {
                    IUrl url = new StringToUrlConverter().convert(inUrl.toString());
                    if (url == null) {
                        throw new CreationException("Couldn't create resource description for url '" + inUrl.toString() + "'");
                    }
                    return new HttpConnectionDescription(url.getHostname(), url.getPort(), url.getPathString(), url.getUserName(), url.getPassword(), url.getQuery(), Optional.of((Object)url.getScheme()).accept(s -> !s.isEmpty()).convert(s -> (String)s.get(s.size() - 1)).accept(p -> "https".equalsIgnoreCase((String)p)).isAccepted());
                }
                catch (ConversionException exception) {
                    throw new CreationException("Couldn't create resource description for url '" + inUrl.toString() + "'", (Throwable)exception);
                }
            }

            public IConnectionDescription visitURIResource(URIResourceReference uriResourceReference) throws RuntimeException, CreationException {
                URI uri = uriResourceReference.getUri();
                if ("file".equals(uri.getScheme())) {
                    return new FileConnectionDescription(new ResourceReferenceFactory().create(new File(uri.getPath())));
                }
                try {
                    IUrl url = new StringToUrlConverter().convert(uri.toString());
                    if (url == null) {
                        throw new CreationException("Couldn't create resource description for url '" + uri.toString() + "'");
                    }
                    return new HttpConnectionDescription(url.getHostname(), url.getPort(), url.getPathString(), url.getUserName(), url.getPassword(), url.getQuery(), Optional.of((Object)url.getScheme()).accept(s -> !s.isEmpty()).convert(s -> (String)s.get(s.size() - 1)).accept(p -> "https".equalsIgnoreCase((String)p)).isAccepted());
                }
                catch (ConversionException exception) {
                    throw new CreationException("Couldn't create resource description for url '" + uri.toString() + "'", (Throwable)exception);
                }
            }

            public IConnectionDescription visitMemoryResource(MemoryResourceReference memoryResourceReference) throws RuntimeException {
                return new MemoryConnectionDescription((Serializable)memoryResourceReference, memoryResourceReference.getContentType(), ZonedDateTime.ofInstant(memoryResourceReference.creationTime().toInstant(), Clock.systemDefaultZone().getZone()));
            }

            public IConnectionDescription visitPathResource(PathResourceReference pathResourceReference) throws RuntimeException {
                return new FileConnectionDescription((IResourceReference)pathResourceReference);
            }
        });
        return new ResourceDescription(connectionDescription);
    }

    public static ResourceDescription of(IConnectionDescription connectionDescription) {
        return new ResourceDescription(connectionDescription);
    }

    ResourceDescription(IConnectionDescription connectionDescription) {
        this.connectionDescription = connectionDescription;
    }

    @Override
    public IConnectionDescription getConnectionDescription() {
        return this.connectionDescription;
    }

    @Override
    public String getUrl() {
        return this.connectionDescription.getUrl();
    }

    @Override
    public IResourceDescription adapt(IAuthentication authentication) {
        return new ResourceDescription(this.connectionDescription.adapt(authentication));
    }
}

