/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.ensure;

import java.text.MessageFormat;
import java.util.Objects;
import net.anwiba.commons.ensure.AbstractCondition;
import net.anwiba.commons.ensure.Ensure;

public class GreaterEqualsCondition<T extends Comparable<T>>
extends AbstractCondition<T> {
    private final Comparable<T> expected;

    public GreaterEqualsCondition(Comparable<T> expected) {
        this.expected = expected;
    }

    @Override
    public boolean accept(T value) {
        Ensure.ensureArgumentNotNull(value);
        return this.expected.compareTo(value) <= 0;
    }

    @Override
    public String toText() {
        return MessageFormat.format("is greater equals {0}", Objects.toString(this.expected));
    }
}

