/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.ensure;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Objects;
import net.anwiba.commons.ensure.AbstractCondition;
import net.anwiba.commons.ensure.Ensure;

public class CollectionContainsCondition<V, T extends Collection<V>>
extends AbstractCondition<T> {
    private final Collection<V> values;

    public CollectionContainsCondition(Collection<V> values) {
        this.values = values;
    }

    @Override
    public boolean accept(T value) {
        Ensure.ensureArgumentNotNull(value);
        return value.containsAll(this.values);
    }

    @Override
    public String toText() {
        return MessageFormat.format("contains ''{0}''", Objects.toString(this.values));
    }
}

