/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.ensure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import net.anwiba.commons.ensure.AllOfCondition;
import net.anwiba.commons.ensure.AnyOfCondition;
import net.anwiba.commons.ensure.BetweenCondition;
import net.anwiba.commons.ensure.CollectionContainsCondition;
import net.anwiba.commons.ensure.CollectionContainsNullCondition;
import net.anwiba.commons.ensure.CollectionSizeCondition;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.ensure.EqualToCondition;
import net.anwiba.commons.ensure.GreaterEqualsCondition;
import net.anwiba.commons.ensure.GreaterThanCondition;
import net.anwiba.commons.ensure.ICondition;
import net.anwiba.commons.ensure.InCondition;
import net.anwiba.commons.ensure.InstanceOfCondition;
import net.anwiba.commons.ensure.IsEmptyCollectionCondition;
import net.anwiba.commons.ensure.IsNullCondition;
import net.anwiba.commons.ensure.IsTrueCondition;
import net.anwiba.commons.ensure.LowerThanCondition;
import net.anwiba.commons.ensure.NotCondition;
import net.anwiba.commons.ensure.StringContainsCondition;
import net.anwiba.commons.ensure.StringEndsWithCondition;
import net.anwiba.commons.ensure.StringStartsWithCondition;

public class Conditions {
    public static <T> ICondition<T> equalTo(T value) {
        return new EqualToCondition<T>(value);
    }

    public static <T> ICondition<T> notNull() {
        return new NotCondition(new IsNullCondition());
    }

    public static <T> ICondition<T> isNull() {
        return new IsNullCondition();
    }

    public static ICondition<Boolean> isTrue() {
        return new IsTrueCondition();
    }

    public static ICondition<Boolean> isFalse() {
        return new NotCondition<Boolean>(new IsTrueCondition());
    }

    @SafeVarargs
    public static <T> ICondition<T> in(T ... values) {
        return Conditions.in(Arrays.asList(values));
    }

    public static <T> ICondition<T> in(Collection<T> collection) {
        return new InCondition(collection == null ? new ArrayList() : collection);
    }

    public static <T> ICondition<T> not(ICondition<T> validation) {
        Ensure.ensureArgumentNotNull(validation);
        return new NotCondition<T>(validation);
    }

    public static ICondition<Object> instanceOf(Class<?> value) {
        Ensure.ensureArgumentNotNull(value);
        return new InstanceOfCondition(value);
    }

    public static ICondition<String> contains(String value) {
        Ensure.ensureArgumentNotNull(value);
        return new StringContainsCondition(value);
    }

    public static ICondition<String> startsWith(String value) {
        Ensure.ensureArgumentNotNull(value);
        return new StringStartsWithCondition(value);
    }

    public static <T extends Comparable<T>> ICondition<T> between(T minimum, T maximum) {
        Ensure.ensureArgumentNotNull(minimum);
        Ensure.ensureArgumentNotNull(maximum);
        return new BetweenCondition(minimum, maximum);
    }

    public static <T extends Comparable<T>> ICondition<T> greaterEquals(T value) {
        Ensure.ensureArgumentNotNull(value);
        return new GreaterEqualsCondition(value);
    }

    public static <T extends Comparable<T>> ICondition<T> greaterThan(T value) {
        Ensure.ensureArgumentNotNull(value);
        return new GreaterThanCondition(value);
    }

    public static <T extends Comparable<T>> ICondition<T> lowerThan(T value) {
        Ensure.ensureArgumentNotNull(value);
        return new LowerThanCondition(value);
    }

    public static ICondition<String> endsWith(String value) {
        Ensure.ensureArgumentNotNull(value);
        return new StringEndsWithCondition(value);
    }

    @SafeVarargs
    public static <T> ICondition<T> anyOf(ICondition<T> ... conditions) {
        return new AnyOfCondition(Arrays.stream(conditions).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T> ICondition<T> allOf(ICondition<T> ... conditions) {
        return new AllOfCondition(Arrays.stream(conditions).collect(Collectors.toList()));
    }

    public static <T extends Collection<?>> ICondition<T> isEmpty() {
        return new IsEmptyCollectionCondition();
    }

    @SafeVarargs
    public static <V, T extends Collection<V>> ICondition<T> containsAll(V ... values) {
        return Conditions.containsAll(Arrays.asList(values));
    }

    public static <V, T extends Collection<V>> ICondition<T> containsAll(Collection<V> values) {
        Ensure.ensureArgumentNotNull(values);
        return new CollectionContainsCondition(values);
    }

    public static <V, T extends Collection<V>> ICondition<T> containsNull() {
        return new CollectionContainsNullCondition();
    }

    public static <T extends Collection> ICondition<T> size(int i) {
        return new CollectionSizeCondition(i);
    }
}

