/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http.testing;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.anwiba.commons.http.testing.AbstractRequestProcessor;
import net.anwiba.commons.http.testing.RequestHandler;
import net.anwiba.commons.lang.functional.IApplicable;
import net.anwiba.commons.lang.object.ObjectPair;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;

public class HttpServerBuilder {
    private int port = 8000;
    private final List<ObjectPair<IApplicable<ObjectPair<String, HttpServletRequest>>, AbstractRequestProcessor>> processors = new ArrayList<ObjectPair<IApplicable<ObjectPair<String, HttpServletRequest>>, AbstractRequestProcessor>>();
    private AbstractRequestProcessor fallbackProcessor;

    public Server build() {
        Server server = new Server(this.port);
        server.setHandler((Handler)new RequestHandler(this.processors, this.fallbackProcessor));
        return server;
    }

    public HttpServerBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public HttpServerBuilder addProcessorForTarget(String target, AbstractRequestProcessor processor) {
        return this.addProcessorForTarget((IApplicable<String>)((IApplicable)value -> Objects.equals(value, target)), processor);
    }

    public HttpServerBuilder addProcessorForTarget(IApplicable<String> applicable, AbstractRequestProcessor processor) {
        this.processors.add((ObjectPair<IApplicable<ObjectPair<String, HttpServletRequest>>, AbstractRequestProcessor>)ObjectPair.of(context -> applicable.isApplicable((Object)((String)context.getFirstObject())), (Object)processor));
        return this;
    }

    public HttpServerBuilder addProcessorForRequest(IApplicable<HttpServletRequest> applicable, AbstractRequestProcessor processor) {
        this.processors.add((ObjectPair<IApplicable<ObjectPair<String, HttpServletRequest>>, AbstractRequestProcessor>)ObjectPair.of(context -> applicable.isApplicable((Object)((HttpServletRequest)context.getSecondObject())), (Object)processor));
        return this;
    }

    public HttpServerBuilder setFallbackProcessor(AbstractRequestProcessor fallbackProcessor) {
        this.fallbackProcessor = fallbackProcessor;
        return this;
    }
}

