/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http.testing;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.anwiba.commons.http.testing.AbstractRequestProcessor;
import net.anwiba.commons.http.testing.IRequestRecorder;
import net.anwiba.commons.http.testing.IResponseContentProvider;
import net.anwiba.commons.reference.utilities.IoUtilities;

public class RequestProcessorBuilder {
    AbstractRequestProcessor.Continue continuing = AbstractRequestProcessor.Continue.FALSE;
    private IResponseContentProvider responseContentProvider = new IResponseContentProvider(){

        @Override
        public byte[] getResponseBytes() throws IOException {
            return new byte[0];
        }
    };
    private IRequestRecorder recorder = new IRequestRecorder(){

        @Override
        public void add(HttpServletRequest request) {
        }
    };
    private int statusCode = 200;
    private String contentType = "text/plain; charset=utf-8";

    public AbstractRequestProcessor build() {
        return new AbstractRequestProcessor(){

            @Override
            protected AbstractRequestProcessor.Continue process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                RequestProcessorBuilder.this.recorder.add(request);
                try {
                    response.setStatus(RequestProcessorBuilder.this.statusCode);
                    response.setContentLength(-1);
                    response.setContentType(RequestProcessorBuilder.this.contentType);
                    byte[] responseBytes = RequestProcessorBuilder.this.responseContentProvider.getResponseBytes();
                    response.setContentLength(responseBytes.length);
                    response.getOutputStream().write(responseBytes);
                    response.flushBuffer();
                    return RequestProcessorBuilder.this.continuing;
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                    throw exception;
                }
                catch (RuntimeException exception) {
                    exception.printStackTrace();
                    throw exception;
                }
            }
        };
    }

    public RequestProcessorBuilder setRequestRecorder(IRequestRecorder recorder) {
        this.recorder = recorder;
        return this;
    }

    public RequestProcessorBuilder setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public RequestProcessorBuilder setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public RequestProcessorBuilder setResponseContent(final File file) {
        this.responseContentProvider = new IResponseContentProvider(){

            @Override
            public byte[] getResponseBytes() throws IOException {
                return this.getResponseBytes(file);
            }

            private byte[] getResponseBytes(File file2) throws FileNotFoundException, IOException {
                try (FileInputStream fileInputStream = new FileInputStream(file2);){
                    byte[] responseBytes;
                    byte[] byArray = responseBytes = this.getBytes(fileInputStream);
                    return byArray;
                }
            }

            private byte[] getBytes(InputStream fileInputStream) throws IOException {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IoUtilities.pipe((InputStream)fileInputStream, (OutputStream)byteArrayOutputStream);
                byte[] response = byteArrayOutputStream.toByteArray();
                return response;
            }
        };
        return this;
    }

    public RequestProcessorBuilder setResponseContent(final String string) {
        this.responseContentProvider = new IResponseContentProvider(){

            @Override
            public byte[] getResponseBytes() throws IOException {
                return string.getBytes();
            }
        };
        return this;
    }

    public RequestProcessorBuilder setResponseContent(final byte[] array) {
        this.responseContentProvider = new IResponseContentProvider(){

            @Override
            public byte[] getResponseBytes() throws IOException {
                return array;
            }
        };
        return this;
    }
}

