/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http.testing;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import net.anwiba.commons.http.testing.AbstractRequestValidator;
import net.anwiba.commons.http.testing.IRequestRecorder;
import net.anwiba.commons.http.testing.RequestedQueryStringValidator;
import net.anwiba.commons.lang.optional.Optional;

public final class RequestValidatorRecorder
implements IRequestRecorder {
    private final String[] expectedQueries;
    private final Queue<AbstractRequestValidator> requestValidators;
    private final Queue<String> expectedQueryStack;

    public RequestValidatorRecorder(Queue<AbstractRequestValidator> requestValidators, String ... expectedQueries) {
        this.requestValidators = requestValidators;
        this.expectedQueries = expectedQueries;
        this.expectedQueryStack = new LinkedList<String>(Arrays.asList(this.expectedQueries));
    }

    @Override
    public void add(HttpServletRequest request) {
        Optional.of((Object)this.expectedQueryStack.poll()).consume(expectedQuery -> this.requestValidators.add(new RequestedQueryStringValidator((String)expectedQuery, request.getQueryString())));
    }
}

