/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import net.anwiba.commons.http.IHttpClientConfiguration;
import net.anwiba.commons.http.IHttpClientFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultClientConnectionReuseStrategy;
import org.apache.http.impl.client.HttpClients;

public class HttpClientFactory
implements IHttpClientFactory {
    private final IHttpClientConfiguration configuration;

    public HttpClientFactory(IHttpClientConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public CloseableHttpClient create() {
        switch (this.configuration.getMode()) {
            case CLOSE: {
                return HttpClients.custom().setConnectionReuseStrategy((ConnectionReuseStrategy)NoConnectionReuseStrategy.INSTANCE).setConnectionManager(this.configuration.getManager()).build();
            }
            case KEEP_ALIVE: {
                return HttpClients.custom().setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultClientConnectionReuseStrategy.INSTANCE).setConnectionManager(this.configuration.getManager()).build();
            }
        }
        return HttpClients.custom().setConnectionManager(this.configuration.getManager()).build();
    }

    @Override
    public IHttpClientConfiguration getClientConfiguration() {
        return this.configuration;
    }
}

