/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http.apache;

import net.anwiba.commons.http.IAuthentication;
import net.anwiba.commons.http.IRequest;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;

public final class HttpContextFactory {
    public HttpContext create(IRequest request) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        IAuthentication authentication = request.getAuthentication();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(authentication.getUsername(), authentication.getPassword()));
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(new HttpHost(request.getHost(), request.getPort(), request.getUriString().toLowerCase().startsWith("https:") ? "https" : "http"), (AuthScheme)new BasicScheme());
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        context.setAuthCache((AuthCache)authCache);
        return context;
    }
}

