/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import net.anwiba.commons.http.IHttpRequestExcecutorFactory;
import net.anwiba.commons.http.IHttpRequestExecutor;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.IResponse;
import net.anwiba.commons.http.RequestBuilder;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.process.cancel.ICanceler;
import net.anwiba.commons.resource.reference.IStreamConnector;

public final class HttpClientConnector
implements IStreamConnector<URI> {
    private static ILogger logger = Logging.getLogger((String)HttpClientConnector.class.getName());
    private final IHttpRequestExcecutorFactory httpRequestExcecutorFactory;

    public HttpClientConnector(IHttpRequestExcecutorFactory httpRequestExcecutorFactory) {
        this.httpRequestExcecutorFactory = httpRequestExcecutorFactory;
    }

    private IHttpRequestExecutor requestExecutor() {
        return this.httpRequestExcecutorFactory.create();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exist(URI uri) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                IResponse response = this.response(uri);
                try {
                    if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                        return true;
                    }
                    logger.log(ILevel.WARNING, "connect to " + uri.toString() + "faild " + response.getStatusCode() + " " + response.getStatusText());
                    if (logger.isLoggable(ILevel.DEBUG)) {
                        logger.log(ILevel.DEBUG, response.getBody());
                    }
                    return false;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (response == null) return true;
                    response.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException | InterruptedException exception) {
            logger.log(ILevel.WARNING, "connect to " + uri.toString() + "faild " + exception.getMessage());
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    private IResponse response(URI uri) throws InterruptedException, IOException {
        IRequest request = this.request(uri);
        return this.requestExecutor().execute(ICanceler.DummyCancler, request);
    }

    private IRequest request(URI uri) {
        return RequestBuilder.get(uri.toString()).build();
    }

    public boolean canRead(URI uri) {
        Throwable throwable = null;
        Object var3_5 = null;
        InputStream inputStream = this.openInputStream(uri);
        if (inputStream != null) {
            inputStream.close();
        }
        try {
            return true;
        }
        catch (Throwable throwable2) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                throw throwable2;
            }
            catch (Throwable throwable3) {
                try {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                    return false;
                }
            }
        }
    }

    public boolean canWrite(URI uri) {
        return false;
    }

    public InputStream openInputStream(URI uri) throws IOException {
        try {
            IResponse response = this.response(uri);
            if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                return response.getInputStream();
            }
            logger.log(ILevel.DEBUG, "connect to " + uri.toString() + "faild " + response.getStatusCode() + " " + response.getStatusText());
            if (logger.isLoggable(ILevel.DEBUG)) {
                logger.log(ILevel.DEBUG, response.getBody());
            }
            throw new IOException(response.getStatusText());
        }
        catch (IOException | InterruptedException exception) {
            logger.log(ILevel.DEBUG, "connect to " + uri.toString() + "faild " + exception.getMessage());
            throw new IOException(exception);
        }
    }

    public OutputStream openOutputStream(URI uri) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long getContentLength(URI uri) throws IOException {
        IResponse response;
        block16: {
            long l;
            block17: {
                Throwable throwable = null;
                Object var3_4 = null;
                response = this.response(uri);
                try {
                    int statusCode = response.getStatusCode();
                    if (200 > statusCode || statusCode >= 300) break block16;
                    l = response.getContentLength();
                    if (response == null) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        if (response != null) {
                            response.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        try {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                        catch (IOException | InterruptedException exception) {
                            return -1L;
                        }
                    }
                }
                response.close();
            }
            return l;
        }
        if (response != null) {
            response.close();
        }
        return -1L;
    }
}

