/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Optional;
import net.anwiba.commons.http.IHttpClientFactory;
import net.anwiba.commons.http.IHttpRequestExecutor;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.IResponse;
import net.anwiba.commons.http.Response;
import net.anwiba.commons.http.apache.InputStreamEntity;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.process.cancel.ICanceler;
import net.anwiba.commons.utilities.parameter.IParameter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;

public class HttpRequestExecutor
implements IHttpRequestExecutor {
    private static ILogger logger = Logging.getLogger((String)HttpRequestExecutor.class.getName());
    private final IHttpClientFactory httpClientFactory;

    public HttpRequestExecutor(IHttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    @Override
    public IResponse execute(ICanceler canceler, IRequest request) throws InterruptedException, IOException {
        HttpUriRequest method = this.create(request);
        logger.log(ILevel.DEBUG, () -> MessageFormat.format("request url: <{0}>", method.getURI()));
        HttpClient client = this.httpClientFactory.create();
        canceler.check();
        HttpResponse response = client.execute(method);
        return new Response(canceler, client, response);
    }

    private HttpUriRequest create(IRequest request) {
        switch (request.getMethodType()) {
            case POST: {
                RequestBuilder requestBuilder = RequestBuilder.post((String)request.getUriString());
                Iterable parameters = request.getParameters().parameters();
                for (IParameter parameter : parameters) {
                    requestBuilder.addParameter(parameter.getName(), parameter.getValue());
                }
                Optional.ofNullable(request.getUserAgent()).ifPresent(value -> {
                    RequestBuilder requestBuilder2 = requestBuilder.addHeader("User-Agent", value);
                });
                HttpEntity entity = this.createEntity(request);
                requestBuilder.setEntity(entity);
                return requestBuilder.build();
            }
            case GET: {
                RequestBuilder requestBuilder = RequestBuilder.get((String)request.getUriString());
                Iterable parameters = request.getParameters().parameters();
                for (IParameter parameter : parameters) {
                    requestBuilder.addParameter(parameter.getName(), parameter.getValue());
                }
                Optional.ofNullable(request.getUserAgent()).ifPresent(value -> {
                    RequestBuilder requestBuilder2 = requestBuilder.addHeader("User-Agent", value);
                });
                return requestBuilder.build();
            }
        }
        throw new UnreachableCodeReachedException();
    }

    public HttpEntity createEntity(IRequest request) {
        String encoding = request.getEncoding();
        Charset charset = encoding == null ? null : Charset.forName(encoding);
        ContentType contentType = ContentType.create((String)request.getMimeType(), (Charset)charset);
        return new InputStreamEntity(request.getContent(), request.getContentLength(), contentType);
    }
}

