/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.http.HttpMethodType;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.Request;
import net.anwiba.commons.lang.functional.IClosure;
import net.anwiba.commons.utilities.parameter.IParameter;
import net.anwiba.commons.utilities.parameter.IParameters;
import net.anwiba.commons.utilities.parameter.Parameter;
import net.anwiba.commons.utilities.parameter.Parameters;

public class RequestBuilder {
    private HttpMethodType httpMethodType = HttpMethodType.GET;
    private final String urlString;
    private final List<IParameter> queryParameters = new ArrayList<IParameter>();
    IClosure<InputStream, IOException> inputStreamClosure;
    private long contentLenght;
    private String encoding;
    private String mimeType;
    private String userAgent;

    public static RequestBuilder get(String urlString) {
        return new RequestBuilder(urlString).get();
    }

    public static RequestBuilder post(String urlString) {
        return new RequestBuilder(urlString).post();
    }

    private RequestBuilder(String urlString) {
        this.urlString = urlString;
    }

    private RequestBuilder post() {
        this.httpMethodType = HttpMethodType.POST;
        return this;
    }

    private RequestBuilder get() {
        this.httpMethodType = HttpMethodType.GET;
        return this;
    }

    public IRequest build() {
        return new Request(this.httpMethodType, this.urlString, (IParameters)new Parameters(this.queryParameters), this.userAgent, this.inputStreamClosure, this.contentLenght, this.encoding, this.mimeType);
    }

    public RequestBuilder query(String key, String value) {
        this.queryParameters.add((IParameter)new Parameter(key, value));
        return this;
    }

    public RequestBuilder query(IParameter parameter) {
        this.queryParameters.add(parameter);
        return this;
    }

    public RequestBuilder content(byte[] content) {
        this.contentLenght = content.length;
        this.inputStreamClosure = () -> new ByteArrayInputStream(content);
        return this;
    }

    public RequestBuilder contentEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public RequestBuilder mimeType(String mimeTye) {
        this.mimeType = mimeTye;
        return this;
    }

    public RequestBuilder userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }
}

