/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.IOException;
import java.io.InputStream;
import net.anwiba.commons.http.HttpRequestException;
import net.anwiba.commons.http.IApplicableHttpResponseExceptionFactory;
import net.anwiba.commons.http.IResultProducer;
import net.anwiba.commons.process.cancel.ICanceler;
import net.anwiba.commons.resource.utilities.IoUtilities;

public final class ExceptionProducer
implements IResultProducer<IOException> {
    private final IApplicableHttpResponseExceptionFactory[] exceptionFactories;

    public ExceptionProducer(IApplicableHttpResponseExceptionFactory ... exceptionFactories) {
        this.exceptionFactories = exceptionFactories;
    }

    @Override
    public IOException execute(ICanceler canceler, int statusCode, String statusMessage, String contentType, String contentEncoding, InputStream inputStream) throws IOException, InterruptedException {
        IApplicableHttpResponseExceptionFactory[] iApplicableHttpResponseExceptionFactoryArray = this.exceptionFactories;
        int n = this.exceptionFactories.length;
        int n2 = 0;
        while (n2 < n) {
            IApplicableHttpResponseExceptionFactory exceptionFactory = iApplicableHttpResponseExceptionFactoryArray[n2];
            if (exceptionFactory.isApplicable(contentType)) {
                return exceptionFactory.create(statusCode, statusMessage, contentEncoding, inputStream);
            }
            ++n2;
        }
        byte[] array = IoUtilities.toByteArray((InputStream)inputStream);
        throw new HttpRequestException("Unexpected response content type '" + contentType + "'", statusCode, statusMessage, array, contentType, contentEncoding);
    }
}

