/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.anwiba.commons.http.ConvertingHttpRequestExecutorBuilder;
import net.anwiba.commons.http.IApplicableHttpResponseExceptionFactory;
import net.anwiba.commons.http.IConvertingHttpRequestExecutor;
import net.anwiba.commons.http.IHttpClientConnectionManagerProvider;
import net.anwiba.commons.http.IHttpResponseExceptionFactory;
import net.anwiba.commons.http.IObjectRequestExecutor;
import net.anwiba.commons.http.IObjectRequestExecutorBuilder;
import net.anwiba.commons.http.IResultProducer;
import net.anwiba.commons.lang.functional.IApplicable;

public class ObjectRequestExecutorBuilder<T>
implements IObjectRequestExecutorBuilder<T> {
    private final ConvertingHttpRequestExecutorBuilder builder = new ConvertingHttpRequestExecutorBuilder();
    private final List<IApplicableHttpResponseExceptionFactory> applicableHttpResponseExceptionFactories = new ArrayList<IApplicableHttpResponseExceptionFactory>();
    private IResultProducer<T> resultProducer = null;

    @Override
    public IObjectRequestExecutorBuilder<T> setConnectionManagerProvider(IHttpClientConnectionManagerProvider connectionManagerProvider) {
        this.builder.setConnectionManagerProvider(connectionManagerProvider);
        return this;
    }

    @Override
    public IObjectRequestExecutorBuilder<T> useAlwaysTheSameConnection() {
        this.builder.useAlwaysTheSameConnection();
        return this;
    }

    @Override
    public IObjectRequestExecutorBuilder<T> useAlwaysANewConnection() {
        this.builder.useAlwaysANewConnection();
        return this;
    }

    @Override
    public IObjectRequestExecutorBuilder<T> setResultProducer(IResultProducer<T> resultProducer) {
        this.resultProducer = resultProducer;
        return this;
    }

    @Override
    public IObjectRequestExecutorBuilder<T> addExceptionFactory(IApplicableHttpResponseExceptionFactory factory) {
        this.applicableHttpResponseExceptionFactories.add(factory);
        return this;
    }

    @Override
    public IObjectRequestExecutorBuilder<T> addExceptionFactory(final IApplicable<String> applicable, final IHttpResponseExceptionFactory factory) {
        return this.addExceptionFactory(new IApplicableHttpResponseExceptionFactory(){

            @Override
            public IOException create(int statusCode, String statusMessage, String contentEncoding, InputStream inputStream) throws IOException {
                return factory.create(statusCode, statusMessage, contentEncoding, inputStream);
            }

            @Override
            public boolean isApplicable(String contentType) {
                return applicable.isApplicable((Object)contentType);
            }
        });
    }

    @Override
    public IObjectRequestExecutor<T> build() {
        IConvertingHttpRequestExecutor convertingExecutor = this.builder.build();
        IResultProducer producer = Optional.ofNullable(this.resultProducer).orElseGet(() -> (canceler, statusCode, statusMessage, contentType, contentEncoding, inputStream) -> null);
        IApplicableHttpResponseExceptionFactory[] exceptionFactories = (IApplicableHttpResponseExceptionFactory[])this.applicableHttpResponseExceptionFactories.stream().toArray(IApplicableHttpResponseExceptionFactory[]::new);
        return (cancelable, request) -> convertingExecutor.execute(cancelable, request, producer, exceptionFactories);
    }
}

