/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.IOException;
import java.io.InputStream;
import net.anwiba.commons.http.CancelableInputStream;
import net.anwiba.commons.http.IResponse;
import net.anwiba.commons.resource.utilities.IoUtilities;
import net.anwiba.commons.thread.cancel.ICanceler;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;

public final class Response
implements IResponse {
    private final HttpClient client;
    private final HttpResponse response;
    private final ICanceler cancelable;

    public Response(ICanceler cancelable, HttpClient client, HttpResponse response) {
        this.cancelable = cancelable;
        this.client = client;
        this.response = response;
    }

    @Override
    public String getBody() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream inputStream = this.getInputStream();){
            return IoUtilities.toString((InputStream)inputStream, (String)this.getContentEncoding());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public String getStatusText() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new CancelableInputStream(this.cancelable, this.response.getEntity().getContent());
    }

    @Override
    public long getContentLength() {
        return this.response.getEntity().getContentLength();
    }

    @Override
    public String getContentType() {
        Header contentType = this.response.getEntity().getContentType();
        if (contentType == null) {
            return null;
        }
        return contentType.getValue();
    }

    @Override
    public String getContentEncoding() {
        Header contentEncoding = this.response.getEntity().getContentEncoding();
        if (contentEncoding == null) {
            return "UTF-8";
        }
        return contentEncoding.getValue();
    }

    @Override
    public void close() throws IOException {
        if (this.response instanceof CloseableHttpResponse) {
            ((CloseableHttpResponse)this.response).close();
        }
    }
}

