/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http.apache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import net.anwiba.commons.lang.functional.IClosure;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;

public class InputStreamEntity
extends AbstractHttpEntity {
    private final IClosure<InputStream, IOException> content;
    private final long length;

    public InputStreamEntity(IClosure<InputStream, IOException> contentClosure, long length, ContentType contentType) {
        this.content = Objects.requireNonNull(contentClosure, "no content");
        this.length = length;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public boolean isRepeatable() {
        return false;
    }

    public long getContentLength() {
        return this.length;
    }

    public InputStream getContent() throws IOException {
        return (InputStream)this.content.execute();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        block13: {
            Objects.requireNonNull(outstream, "no content");
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream instream = (InputStream)this.content.execute();){
                byte[] buffer = new byte[4096];
                if (this.length < 0L) {
                    int size;
                    while ((size = instream.read(buffer)) != -1) {
                        outstream.write(buffer, 0, size);
                    }
                    break block13;
                }
                long remaining = this.length;
                while (remaining > 0L) {
                    int size = instream.read(buffer, 0, (int)Math.min(4096L, remaining));
                    if (size == -1) {
                        break;
                    }
                    outstream.write(buffer, 0, size);
                    remaining -= (long)size;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public boolean isStreaming() {
        return true;
    }
}

