/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import net.anwiba.commons.http.HttpRequestException;
import net.anwiba.commons.http.IHttpRequestExecutor;
import net.anwiba.commons.http.IHttpRequestExecutorFactory;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.IResponse;
import net.anwiba.commons.http.RequestBuilder;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.IStreamConnector;
import net.anwiba.commons.thread.cancel.ICanceler;

public final class HttpClientConnector
implements IStreamConnector<URI> {
    private static ILogger logger = Logging.getLogger((String)HttpClientConnector.class.getName());
    private final IHttpRequestExecutorFactory httpRequestExcecutorFactory;

    public HttpClientConnector(IHttpRequestExecutorFactory httpRequestExcecutorFactory) {
        this.httpRequestExcecutorFactory = httpRequestExcecutorFactory;
    }

    private IHttpRequestExecutor requestExecutor() {
        return this.httpRequestExcecutorFactory.create();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exist(URI uri) {
        try (IResponse response = this.response(uri);){
            if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                boolean bl2 = true;
                return bl2;
            }
            logger.log(ILevel.WARNING, "connect to '" + uri.toString() + "' faild " + response.getStatusCode() + " " + response.getStatusText());
            if (logger.isLoggable(ILevel.DEBUG)) {
                logger.log(ILevel.DEBUG, response.getBody());
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException | CanceledException exception) {
            logger.log(ILevel.WARNING, "connect to '" + uri.toString() + "' faild " + exception.getMessage());
            logger.log(ILevel.DEBUG, exception.getMessage(), exception);
            return false;
        }
    }

    private IResponse response(URI uri) throws CanceledException, IOException {
        try {
            IRequest request = this.request(uri);
            return this.requestExecutor().execute(ICanceler.DummyCanceler, request);
        }
        catch (CreationException exception) {
            throw new IOException(exception.getMessage(), exception);
        }
    }

    private IRequest request(URI uri) throws CreationException {
        return RequestBuilder.get(uri.toString()).build();
    }

    public boolean canRead(URI uri) {
        boolean bl;
        block8: {
            InputStream inputStream = this.openInputStream(uri);
            try {
                bl = true;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    public boolean canWrite(URI uri) {
        return false;
    }

    public InputStream openInputStream(URI uri) throws IOException {
        return this.openInputStream(uri, (IAcceptor<String>)((IAcceptor)s -> true));
    }

    public InputStream openInputStream(URI uri, IAcceptor<String> contentTypeAcceptor) throws IOException {
        try {
            final IResponse response = this.response(uri);
            if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                if (!contentTypeAcceptor.accept((Object)response.getContentType())) {
                    throw HttpRequestException.create("Unexcepted mime type '" + response.getContentType() + "'", response);
                }
                return new FilterInputStream(response.getInputStream()){

                    @Override
                    public void close() throws IOException {
                        response.close();
                    }
                };
            }
            logger.log(ILevel.DEBUG, "connect to '" + uri.toString() + "' faild " + response.getStatusCode() + " " + response.getStatusText());
            if (logger.isLoggable(ILevel.DEBUG)) {
                logger.log(ILevel.DEBUG, response.getBody());
            }
            throw HttpRequestException.create(response.getStatusCode() + " - " + response.getStatusText(), response);
        }
        catch (IOException | CanceledException exception) {
            logger.log(ILevel.DEBUG, "connect to '" + uri.toString() + "' faild " + exception.getMessage());
            throw new IOException(exception);
        }
    }

    public OutputStream openOutputStream(URI uri) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getContentLength(URI uri) throws IOException {
        try (IResponse response = this.response(uri);){
            int statusCode = response.getStatusCode();
            if (200 <= statusCode && statusCode < 300) {
                long l2 = response.getContentLength();
                return l2;
            }
            long l = -1L;
            return l;
        }
        catch (IOException | CanceledException exception) {
            return -1L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getContentType(URI uri) throws IOException {
        try (IResponse response = this.response(uri);){
            int statusCode = response.getStatusCode();
            if (200 <= statusCode && statusCode < 300) {
                String string2 = response.getContentType();
                return string2;
            }
            String string = null;
            return string;
        }
        catch (IOException | CanceledException exception) {
            return null;
        }
    }
}

